% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R
\name{tiling_correlogramcpp_index}
\alias{tiling_correlogramcpp_index}
\title{Compute STTPs for just two spike trains, A and B}
\usage{
tiling_correlogramcpp_index(spikes, n, nspikes, first_spike, start, end, dt,
  tau_sep, tau_max, a, b)
}
\arguments{
\item{spikes}{Concatenated list of spike trains}

\item{n}{number of spike trains}

\item{nspikes}{Vector containing the number of spikes in each train}

\item{first_spike}{Index to the first spike in each train.}

\item{start}{Start time of recording in seconds}

\item{end}{End time of recording in seconds}

\item{dt}{Coincidence window for STTC}

\item{tau_sep}{Step size for taus.}

\item{tau_max}{Maximum absolute tau value.}

\item{a}{Number of first spike train}

\item{b}{Number of second spike train}
}
\value{
STTP for spike trains a and b
}
\description{
Compute STTP for just one pair of trains
}
\details{
If you have the spikes from an array in a flattened form, you can compute
the STTP for just two of the spike trains, rather than computing all
pairwise STTPs.
}
\author{
Tom Edinburgh
}
