% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_regression.R
\name{ARSQ}
\alias{ARSQ}
\title{Adjusted coefficient of determination}
\usage{
ARSQ(truth, response, n, p)
}
\arguments{
\item{truth}{[numeric] vector of true values}

\item{response}{[numeric] vector of predicted values}

\item{n}{[numeric] number of observations}

\item{p}{[numeric] number of predictors}
}
\description{
Defined as: 1 - (1 - rsq) * (p / (n - p - 1L)). Adjusted R-squared is only defined for normal linear regression.
}
\examples{
n = 20
p = 5
set.seed(123)
truth = rnorm(n)
response = rnorm(n)
ARSQ(truth, response, n, p)
}
