% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CEL-class}
\alias{CEL-class}
\title{S4 class \linkS4class{CEL}}
\description{
S4 class for constrained empirical likelihood. It inherits from
\linkS4class{EL} class. Note that \code{optim} slot has constrained
optimization results with respect to parameters, not the Lagrange multiplier.
}
\details{
Let \eqn{l(\theta)} denote the minus twice the empirical
  log-likelihood ratio function. We consider a linear hypothesis of the form
  \deqn{L\theta = r,} where the left-hand-side \eqn{L} is a \eqn{q} by
  \eqn{p} matrix and the right-hand-side \eqn{r} is a \eqn{q}-dimensional
  vector. Under some regularity conditions, \eqn{l(\theta)} converges in
  distribution to \eqn{\chi^2_q} under the constraint of hypothesis, i.e.,
  \deqn{\min_{\theta: L\theta = r} l(\theta) \to_d \chi^2_q .}

  Minimization of \eqn{l(\theta)} with respect to \eqn{\theta} is
  computationally expensive since it implicitly involves the
  evaluation step as described in \linkS4class{EL}. Further, depending on the
  form of \eqn{g(X_i, \theta)} and the constraint, the optimization problem
  can be nonconvex and have multiple local minima. For this reason,
  \strong{melt} only considers linear hypotheses and performs local
  minimization of \eqn{l(\theta)} using projected gradient descent method.
  With the orthogonal projection matrix \eqn{P} and a step size \eqn{\gamma},
  the algorithm updates \eqn{\theta} as
  \deqn{\theta^{(k + 1)} \leftarrow \theta^{(k)} -
  \gamma P \nabla l(\theta^{(k)}),}
  where \eqn{\nabla l(\theta^{(k)})} denotes the gradient of \eqn{l} at
  \eqn{\theta^{(k)}}. The first order optimality condition is
  \eqn{P \nabla l(\theta) = 0}, which is used as the stopping criterion.
}
\section{Slots}{

\describe{
\item{\code{optim}}{A list with the following optimization results:
\itemize{
\item{\code{method } }{Character for method dispatch in internal
functions.}
\item{\code{par } }{Parameter value that minimizes the constrained
empirical likelihood.}
\item{\code{lambda } }{Lagrange multiplier of the dual problem.}
\item{\code{iterations } }{Number of iterations performed.}
\item{\code{convergence } }{Convergence status.}
}}

\item{\code{logp}}{Log probabilities obtained from constrained empirical likelihood.}

\item{\code{logl}}{Constrained empirical log-likelihood.}

\item{\code{loglr}}{Constrained empirical log-likelihood ratio.}

\item{\code{statistic}}{Minus twice the constrained empirical log-likelihood ratio
statistic that has an asymptotic chi-square distribution.}

\item{\code{df}}{Degrees of freedom of the statistic.}

\item{\code{pval}}{\eqn{p}-value of the statistic.}

\item{\code{npar}}{Number of parameters.}

\item{\code{weights}}{Rescaled weights used for model fitting.}

\item{\code{data}}{Data matrix used for model fitting.}

\item{\code{coefficients}}{Maximum empirical likelihood estimates of the parameters.}
}}

\examples{
showClass("CEL")
}
\references{
Adimari, Gianfranco, and Annamaria Guolo. 2010.
  “A Note on the Asymptotic Behaviour of Empirical Likelihood Statistics.”
  Statistical Methods & Applications 19 (4): 463–76.
  \doi{10.1007/s10260-010-0137-9}.

Qin, Jing, and Jerry Lawless. 1995.
  “Estimating Equations, Empirical Likelihood and Constraints on Parameters.”
  Canadian Journal of Statistics 23 (2): 145–59. \doi{10.2307/3315441}.
}
