% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{aspl}
\alias{aspl}
\title{Average shortest path length (aspl)}
\usage{
aspl(adj, types = "uncorrected", weights = NULL, mode = "undirected")
}
\arguments{
\item{adj}{numeric matrix representing the adjacency matrix.}

\item{types}{character. Either \code{"uncorrected"} or \code{"corrected"}, or
a vector containing both.}

\item{weights}{numeric vector of edge weights. Optional.}

\item{mode}{character, either \code{"directed"} or \code{"undirected"},
specifying whether the network should be interepeted as directed
or undirected. Defaults to \code{"undirected"}.}
}
\value{
Local clustering coefficient.
}
\description{
Computes the average shortest path length (aspl) using \code{igraph}'s automatic
method.
}
\details{
Per default the uncorrected apsl is computed. Otherwise, the uncorrected aspl
is normalized by \code{log(n nodes)/log(average degree)}, i.e., the expected
average shortest path length for an Erdös-Renyi random graph.
}
\examples{

# get fluency data
data(animal_fluency)

# edge lists of fluency graphs
edge_list = threshold_graph(animal_fluency)

# get adjacency matrices
adj = edg_to_adj(edge_list)

# get average shortest path length
aspl(adj)

# get corrected average shortest path length
aspl(adj, types = 'corrected')

}
