% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memoiR.R
\name{build_gitignore}
\alias{build_gitignore}
\title{Build .gitignore}
\usage{
build_gitignore()
}
\value{
The content of the \code{.gitignore} file as a vector of characters, invisibly. Each element is a line of the file.
}
\description{
Build a \code{.gitignore} file suitable for R Markdown projects.
}
\details{
The .gitignore file contains the list of files (file name patterns) that must not be controlled by git.
Run this function once in each project created from a memoiR template, before activating version control.
}
\examples{
## Simulate the creation of a new project
# Save working directory
original_wd <- getwd()
# Get a temporary working directory
wd <- tempfile("example")
# Simulate File > New File > R Markdown... > From Template > Simple Article
rmarkdown::draft(wd, template="simple_article", package="memoiR", edit=FALSE)
# Go to temp directory
setwd(wd)
# Make it the current project
usethis::proj_set(path = ".", force = TRUE)

# Build .gitignore file
build_gitignore()
# Content
readLines(".gitignore")

## End of the example: cleanup
# Return to the original working directory and clean up
setwd(original_wd)
unlink(wd, recursive=TRUE)

}
