% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_colorstrip.R
\name{guide_colourstrip}
\alias{guide_colourstrip}
\alias{guide_train.colorstrip}
\alias{guide_colorstrip}
\alias{guide_gengrob.colorstrip}
\title{Discretized continuous colour guide}
\usage{
guide_colourstrip(
  title = ggplot2::waiver(),
  title.position = NULL,
  title.theme = NULL,
  title.hjust = NULL,
  title.vjust = NULL,
  label = TRUE,
  label.position = NULL,
  label.theme = NULL,
  label.hjust = NULL,
  label.vjust = NULL,
  barwidth = NULL,
  barheight = NULL,
  ticks = FALSE,
  draw.ulim = TRUE,
  draw.llim = TRUE,
  inside = FALSE,
  direction = NULL,
  default.unit = "line",
  reverse = FALSE,
  order = 0,
  available_aes = c("colour", "color", "fill"),
  ...
)

guide_colorstrip(
  title = ggplot2::waiver(),
  title.position = NULL,
  title.theme = NULL,
  title.hjust = NULL,
  title.vjust = NULL,
  label = TRUE,
  label.position = NULL,
  label.theme = NULL,
  label.hjust = NULL,
  label.vjust = NULL,
  barwidth = NULL,
  barheight = NULL,
  ticks = FALSE,
  draw.ulim = TRUE,
  draw.llim = TRUE,
  inside = FALSE,
  direction = NULL,
  default.unit = "line",
  reverse = FALSE,
  order = 0,
  available_aes = c("colour", "color", "fill"),
  ...
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{title.position}{A character string indicating the position of a
title. One of "top" (default for a vertical guide), "bottom", "left"
(default for a horizontal guide), or "right."}

\item{title.theme}{A theme object for rendering the title text. Usually the
object of \code{\link[ggplot2:element_text]{element_text()}} is expected. By default, the theme is
specified by \code{legend.title} in \code{\link[ggplot2:theme]{theme()}} or theme.}

\item{title.hjust}{A number specifying horizontal justification of the
title text.}

\item{title.vjust}{A number specifying vertical justification of the title
text.}

\item{label}{logical. If \code{TRUE} then the labels are drawn. If
\code{FALSE} then the labels are invisible.}

\item{label.position}{A character string indicating the position of a
label. One of "top", "bottom" (default for horizontal guide), "left", or
"right" (default for vertical guide).}

\item{label.theme}{A theme object for rendering the label text. Usually the
object of \code{\link[ggplot2:element_text]{element_text()}} is expected. By default, the theme is
specified by \code{legend.text} in \code{\link[ggplot2:theme]{theme()}}.}

\item{label.hjust}{A numeric specifying horizontal justification of the
label text. The default for standard text is 0 (left-aligned) and 1
(right-aligned) for expressions.}

\item{label.vjust}{A numeric specifying vertical justification of the label
text.}

\item{barwidth}{A numeric or a \code{\link[grid:unit]{grid::unit()}} object specifying
the width of the colourbar. Default value is \code{legend.key.width} or
\code{legend.key.size} in \code{\link[ggplot2:theme]{theme()}} or theme.}

\item{barheight}{A numeric or a \code{\link[grid:unit]{grid::unit()}} object specifying
the height of the colourbar. Default value is \code{legend.key.height} or
\code{legend.key.size} in \code{\link[ggplot2:theme]{theme()}} or theme.}

\item{ticks}{A logical specifying if tick marks on the colourbar should be
visible.}

\item{draw.ulim}{A logical specifying if the upper limit tick marks should
be visible.}

\item{draw.llim}{A logical specifying if the lower limit tick marks should
be visible.}

\item{inside}{logical indicating where to position labels (see examples).}

\item{direction}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical."}

\item{default.unit}{A character string indicating \code{\link[grid:unit]{grid::unit()}}
for \code{barwidth} and \code{barheight}.}

\item{reverse}{logical. If \code{TRUE} the colourbar is reversed. By default,
the highest value is on the top and the lowest value is on the bottom}

\item{order}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}

\item{available_aes}{A vector of character strings listing the aesthetics
for which a colourbar can be drawn.}

\item{...}{ignored.}
}
\value{
A guide object.
}
\description{
A version of \link[ggplot2:guide_colourbar]{ggplot2::guide_colourbar} that displays discretized values and,
by default, puts labels in between values.
}
\details{
The default behaviour works fell for geom_contour_fill in which the colours
represent the value between contour surfaces.

`inside = TRUE`` works better for geom_tile where the colour represents
the value of the data and is very similar to \link[ggplot2:guide_legend]{ggplot2::guide_legend}.
}
\examples{
# In this example the lowest colour represents an area of the data with values
# between 80 and 100.
library(ggplot2)
binwidth <- 20
data(volcano)
ggplot(reshape2::melt(volcano), aes(Var1, Var2, z = value)) +
    geom_contour_fill(binwidth = binwidth) +
    scale_fill_continuous(guide = guide_colourstrip(),
                         breaks = MakeBreaks(binwidth))

# Difference between guide_legend() and guide_colorbar2(inside = T)
df <- reshape2::melt(outer(1:4, 1:4), varnames = c("X1", "X2"))
g <- ggplot(df, aes(X1, X2)) +
        geom_tile(aes(fill = value)) +
        theme(legend.position = "bottom")

# Tick labels are to the side
g + scale_fill_continuous(guide = guide_legend())
# Tick labels are at the bottom
g + scale_fill_continuous(guide = guide_colourstrip(inside = TRUE))

}
\seealso{
Other ggplot2 helpers: 
\code{\link{MakeBreaks}()},
\code{\link{WrapCircular}()},
\code{\link{geom_arrow}()},
\code{\link{geom_contour2}()},
\code{\link{geom_contour_fill}()},
\code{\link{geom_label_contour}()},
\code{\link{geom_relief}()},
\code{\link{geom_streamline}()},
\code{\link{map_labels}},
\code{\link{reverselog_trans}()},
\code{\link{scale_divergent}},
\code{\link{scale_longitude}},
\code{\link{stat_na}()},
\code{\link{stat_subset}()}
}
\concept{ggplot2 helpers}
\keyword{internal}
