% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_contour2.r, R/stat_contour2.r
\docType{data}
\name{geom_contour2}
\alias{geom_contour2}
\alias{GeomContour2}
\alias{stat_contour2}
\alias{StatContour2}
\title{2d contours of a 3d surface}
\usage{
geom_contour2(
  mapping = NULL,
  data = NULL,
  stat = "contour2",
  position = "identity",
  ...,
  lineend = "butt",
  linejoin = "round",
  linemitre = 1,
  breaks = MakeBreaks(),
  bins = NULL,
  binwidth = NULL,
  global.breaks = TRUE,
  na.rm = FALSE,
  na.fill = FALSE,
  skip = 1,
  margin = grid::unit(c(1, 1, 1, 1), "pt"),
  label.placer = label_placer_flattest(),
  show.legend = NA,
  inherit.aes = TRUE
)

stat_contour2(
  mapping = NULL,
  data = NULL,
  geom = "contour2",
  position = "identity",
  ...,
  breaks = MakeBreaks(),
  bins = NULL,
  binwidth = NULL,
  proj = NULL,
  clip = NULL,
  kriging = FALSE,
  global.breaks = TRUE,
  na.rm = FALSE,
  na.fill = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{breaks}{One of:
\itemize{
\item A numeric vector of breaks
\item A function that takes the range of the data and binwidth as input
and returns breaks as output
}}

\item{bins}{Number of evenly spaced breaks.}

\item{binwidth}{Distance between breaks.}

\item{global.breaks}{Logical indicating whether \code{breaks} should be computed for the whole
data or for each grouping.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{na.fill}{How to fill missing values.
\itemize{
\item \code{FALSE} for letting the computation fail with no interpolation
\item \code{TRUE} for imputing missing values with \link{Impute2D}
\item A numeric value for constant imputation
\item A function that takes a vector and returns a numeric (e.g. \code{mean})
}}

\item{skip}{number of contours to skip for labelling
(e.g. \code{skip = 1} will skip 1 contour line between labels).}

\item{margin}{the margin around labels around which contour lines
are clipped to avoid overlapping.}

\item{label.placer}{a label placer function. See \code{\link[=label_placer_flattest]{label_placer_flattest()}}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}

\item{proj}{The projection to which to project the contours to.
It can be either a projection string or a function to apply to the whole
contour dataset.}

\item{clip}{A simple features object to be used as a clip. Contours are only
drawn in the interior of this polygon.}

\item{kriging}{Whether to perform ordinary kriging before contouring.
Use this if you want to use contours with irregularly spaced data.
If \code{FALSE}, no kriging is performed. If \code{TRUE}, kriging will be performed with
40 points. If a numeric, kriging will be performed with \code{kriging} points.}
}
\description{
Similar to \link[ggplot2:geom_contour]{ggplot2::geom_contour} but it can label contour lines,
accepts accepts a function as the \code{breaks} argument and and computes
breaks globally instead of per panel.
}
\section{Aesthetics}{

\code{geom_contour2} understands the following aesthetics (required aesthetics are in bold):

Aesthetics related to contour lines:
\itemize{
\item \strong{x}
\item \strong{y}
\item \strong{z}
\item \code{alpha}
\item \code{colour}
\item \code{group}
\item \code{linetype}
\item \code{size}
\item \code{weight}
}

Aesthetics related to labels:
\itemize{
\item \code{label}
\item \code{label_colour}
\item \code{label_alpha}
\item \code{label_size}
\item \code{family}
\item \code{fontface}
}
}

\section{Computed variables}{

\describe{
\item{level}{height of contour}
}
}

\examples{
\dontshow{data.table::setDTthreads(1)}

library(ggplot2)

# Breaks can be a function.
ggplot(reshape2::melt(volcano), aes(Var1, Var2)) +
    geom_contour2(aes(z = value, color = after_stat(level)),
                  breaks = AnchorBreaks(130, binwidth = 10))

# Add labels by supplying the label aes.
ggplot(reshape2::melt(volcano), aes(Var1, Var2)) +
    geom_contour2(aes(z = value, label = after_stat(level)))

ggplot(reshape2::melt(volcano), aes(Var1, Var2)) +
    geom_contour2(aes(z = value, label = after_stat(level)),
                  skip = 0)

# Use label.placer to control where contours are labelled.
ggplot(reshape2::melt(volcano), aes(Var1, Var2)) +
    geom_contour2(aes(z = value, label = after_stat(level)),
                      label.placer = label_placer_n(n = 2))

# Use the rot_adjuster argument of the placer function to
# control the angle. For example, to fix it to some angle:
ggplot(reshape2::melt(volcano), aes(Var1, Var2)) +
    geom_contour2(aes(z = value, label = after_stat(level)),
                  skip = 0,
                  label.placer = label_placer_flattest(rot_adjuster = 0))

}
\seealso{
Other ggplot2 helpers: 
\code{\link{MakeBreaks}()},
\code{\link{WrapCircular}()},
\code{\link{geom_arrow}()},
\code{\link{geom_contour_fill}()},
\code{\link{geom_label_contour}()},
\code{\link{geom_relief}()},
\code{\link{geom_streamline}()},
\code{\link{guide_colourstrip}()},
\code{\link{map_labels}},
\code{\link{reverselog_trans}()},
\code{\link{scale_divergent}},
\code{\link{scale_longitude}},
\code{\link{stat_na}()},
\code{\link{stat_subset}()}

Other ggplot2 helpers: 
\code{\link{MakeBreaks}()},
\code{\link{WrapCircular}()},
\code{\link{geom_arrow}()},
\code{\link{geom_contour_fill}()},
\code{\link{geom_label_contour}()},
\code{\link{geom_relief}()},
\code{\link{geom_streamline}()},
\code{\link{guide_colourstrip}()},
\code{\link{map_labels}},
\code{\link{reverselog_trans}()},
\code{\link{scale_divergent}},
\code{\link{scale_longitude}},
\code{\link{stat_na}()},
\code{\link{stat_subset}()}
}
\concept{ggplot2 helpers}
\keyword{datasets}
