% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVars.R
\name{getVars}
\alias{getVars}
\title{Filter environmental monitoring stations by reported elements}
\usage{
getVars(vars, ...)
}
\arguments{
\item{vars}{(character) Elements(s)/variables(s) of interest.  The user can search for general, environmental terms, such as 'temperature,' or 'wind,' and the function will return environmental stations that collect the specified elements ('fuzzy search').  Keep in mind that the database contains ~107,000 stations, worldwide.  Searching for a general term such as 'temperature' will return many stations. The user is advised to search for more granular terms, e.g., using sub terms such as 'air temperature,' or 'soil temperature,' if they wish to narrow their results.}

\item{...}{auto-populates when called from \code{siteFinder()} wrapper}
}
\value{
A list comprising environmental monitoring sites that observe or collect the element(s)/variable(s) specified in \code{vars}\cr
}
\description{
Return metadata of environmental monitoring stations that collect specific element-level (environmental variables, e.g., air temperature) metadata via 'fuzzy search'.
}
\examples{
\dontrun{
#return a list of sites that collect humidity data
  getVars(vars="humidity")
#return a list of sites that collect soil temperature and/or wind data
  getVars(vars=c("soil temperature","wind"))}
}
\seealso{
\link[metScanR]{siteFinder}
\link[metScanR]{mapSiteFinder}
\link[metScanR]{metScanR_DB}
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
}
\keyword{air}
\keyword{air,}
\keyword{atmopsheric}
\keyword{atmosphere,}
\keyword{canopy,}
\keyword{chemical,}
\keyword{climate,}
\keyword{cloud,}
\keyword{conductivity,}
\keyword{data,}
\keyword{environment,}
\keyword{environmental}
\keyword{flux,}
\keyword{groundwater,}
\keyword{humidity,}
\keyword{in-situ,}
\keyword{lake,}
\keyword{metadata}
\keyword{phenology,}
\keyword{pollution,}
\keyword{precipitation,}
\keyword{radiation,}
\keyword{reservoir,}
\keyword{river,}
\keyword{salinity,}
\keyword{snow,}
\keyword{soil,}
\keyword{soils,}
\keyword{stream,}
\keyword{temperature,}
\keyword{vapor,}
\keyword{water,}
\keyword{weather,}
\keyword{wind,}
