% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.meta.R
\name{print.summary.meta}
\alias{print.summary.meta}
\title{Print detailed meta-analysis results}
\usage{
\method{print}{summary.meta}(
  x,
  sortvar,
  common = x$x$common,
  random = x$x$random,
  details = FALSE,
  ma = TRUE,
  overall = x$overall,
  backtransf = x$backtransf,
  pscale = x$pscale,
  irscale = x$irscale,
  irunit = x$irunit,
  digits = gs("digits"),
  digits.se = gs("digits.se"),
  digits.pval = max(gs("digits.pval"), 2),
  digits.tau2 = gs("digits.tau2"),
  digits.tau = gs("digits.tau"),
  digits.I2 = gs("digits.I2"),
  digits.prop = gs("digits.prop"),
  digits.weight = gs("digits.weight"),
  scientific.pval = gs("scientific.pval"),
  zero.pval = gs("zero.pval"),
  JAMA.pval = gs("JAMA.pval"),
  big.mark = gs("big.mark"),
  text.tau2 = gs("text.tau2"),
  text.tau = gs("text.tau"),
  text.I2 = gs("text.I2"),
  truncate,
  text.truncate = "*** Output truncated ***",
  details.methods = TRUE,
  warn.backtransf = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{summary.meta}}

\item{sortvar}{An optional vector used to sort the individual
studies (must be of same length as \code{x$TE}).}

\item{common}{A logical indicating whether a common effect
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{details}{A logical indicating whether further details of
individual studies should be printed.}

\item{ma}{A logical indicating whether the summary results of the
meta-analysis should be printed.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{backtransf}{A logical indicating whether printed results
should be back transformed. If \code{backtransf = TRUE}, results
for \code{sm = "OR"} are printed as odds ratios rather than log
odds ratios and results for \code{sm = "ZCOR"} are printed as
correlations rather than Fisher's z transformed correlations, for
example.}

\item{pscale}{A numeric giving scaling factor for printing of
single event probabilities or risk differences, i.e. if argument
\code{sm} is equal to \code{"PLOGIT"}, \code{"PLN"},
\code{"PRAW"}, \code{"PAS"}, \code{"PFT"}, or \code{"RD"}.}

\item{irscale}{A numeric defining a scaling factor for printing of
single incidence rates or incidence rate differences, i.e. if
argument \code{sm} is equal to \code{"IR"}, \code{"IRLN"},
\code{"IRS"}, \code{"IRFT"}, or \code{"IRD"}.}

\item{irunit}{A character specifying the time unit used to
calculate rates, e.g. person-years.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard
deviations and standard errors, see \code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for p-value
of test of treatment effect, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance, see \code{print.default}.}

\item{digits.tau}{Minimal number of significant digits for square
root of between-study variance, see \code{print.default}.}

\item{digits.I2}{Minimal number of significant digits for I-squared
and Rb statistic, see \code{print.default}.}

\item{digits.prop}{Minimal number of significant digits for
proportions, see \code{print.default}.}

\item{digits.weight}{Minimal number of significant digits for
weights, see \code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{zero.pval}{A logical specifying whether p-values should be
printed with a leading zero.}

\item{JAMA.pval}{A logical specifying whether p-values for test of
overall effect should be printed according to JAMA reporting
standards.}

\item{big.mark}{A character used as thousands separator.}

\item{text.tau2}{Text printed to identify between-study variance
\eqn{\tau^2}.}

\item{text.tau}{Text printed to identify \eqn{\tau}, the square
root of the between-study variance \eqn{\tau^2}.}

\item{text.I2}{Text printed to identify heterogeneity statistic
I\eqn{^2}.}

\item{truncate}{An optional vector used to truncate the printout of
results for individual studies (must be a logical vector of same
length as \code{x$TE} or contain numerical values).}

\item{text.truncate}{A character string printed if study results
were truncated from the printout.}

\item{details.methods}{A logical specifying whether details on
statistical methods should be printed.}

\item{warn.backtransf}{Deprecated argument (ignored).}

\item{\dots}{Additional arguments (passed on to
\code{\link{print.meta}} called internally).}
}
\description{
Print method for objects of class \code{summary.meta}.
}
\details{
Print method for objects of class \code{summary.meta} giving
detailed information on the meta-analysis.

Argument \code{pscale} can be used to rescale single proportions or
risk differences, e.g. \code{pscale = 1000} means that proportions
are expressed as events per 1000 observations. This is useful in
situations with (very) low event probabilities.

Argument \code{irscale} can be used to rescale single rates or rate
differences, e.g. \code{irscale = 1000} means that rates are
expressed as events per 1000 time units, e.g. person-years. This is
useful in situations with (very) low rates. Argument \code{irunit}
can be used to specify the time unit used in individual studies
(default: "person-years"). This information is printed in summaries
and forest plots if argument \code{irscale} is not equal to 1.
}
\examples{
data(Fleiss1993cont)
m1 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
  data = Fleiss1993cont, sm = "SMD", studlab = paste(study, year))
sm1 <- summary(m1)
sm1

print(sm1, digits = 2)

\dontrun{
# Use unicode characters to print tau^2, tau, and I^2 
print(sm1,
  text.tau2 = "\u03c4\u00b2",
  text.tau = "\u03c4", text.I2 = "I\u00b2")
}

}
\references{
Cooper H & Hedges LV (1994), \emph{The Handbook of
  Research Synthesis}.  Newbury Park, CA: Russell Sage Foundation.

Crippa A, Khudyakov P, Wang M, Orsini N, Spiegelman D (2016), A new measure
of between-studies heterogeneity in meta-analysis.  \emph{Statistics in
Medicine}, \bold{35}, 3661--75.

Higgins JPT & Thompson SG (2002), Quantifying heterogeneity in a
meta-analysis.  \emph{Statistics in Medicine}, \bold{21}, 1539--58.
}
\seealso{
\code{\link{summary.meta}}, \code{\link{update.meta}},
  \code{\link{metabin}}, \code{\link{metacont}},
  \code{\link{metagen}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{print}
