% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimfill.rm5.R
\name{trimfill.rm5}
\alias{trimfill.rm5}
\alias{print.trimfill.rm5}
\title{Cochrane review: trim-and-fill method}
\usage{
\method{trimfill}{rm5}(x, comp.no, outcome.no, ...)

\method{print}{trimfill.rm5}(x, ...)
}
\arguments{
\item{x}{An object of class \code{rm5} or \code{trimfill.rm5}.}

\item{comp.no}{Comparison number.}

\item{outcome.no}{Outcome number.}

\item{...}{Additional arguments (passed on to \code{metacr}).}
}
\description{
Conduct trim-and-fill analysis for all meta-analyses in a Cochrane
review.
}
\details{
This function can be used to conduct a trim-and-fill analysis for
all or selected meta-analyses in a Cochrane review.

Review Manager 5 (RevMan 5) was the software used for preparing and
maintaining Cochrane Reviews
(\url{https://training.cochrane.org/online-learning/core-software/revman}).
Data from a Cochrane review can be imported to R using the function
\code{read.rm5}.

The R function \code{\link{metacr}} is called internally.
}
\examples{
# Locate export data file "Fleiss1993_CR.csv"
# in sub-directory of package "meta"
#
filename <- system.file("extdata", "Fleiss1993_CR.csv", package = "meta")
Fleiss1993_CR <- read.rm5(filename)

# Conduct trim-and-fill analysis
#
trimfill(Fleiss1993_CR)

# Conduct trim-and-fill analysis only for second outcome of first
# comparison
#
trimfill(Fleiss1993_CR, comp.no = 1, outcome.no = 2)

}
\references{
Higgins, J.P.T and S. Green (2011):
\emph{Cochrane Handbook for Systematic Reviews of Interventions
  Version 5.1.0 [Updated March 2011]}.
The Cochrane Library: http://www.cochrane-handbook.org
}
\seealso{
\code{\link{summary.meta}}, \code{\link{metacr}},
  \code{\link{read.rm5}}, \code{\link{metabias.rm5}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
