% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_extraction.R
\name{data_extraction_sheet}
\alias{data_extraction_sheet}
\title{Data extraction sheet generator}
\usage{
data_extraction_sheet(
  measure = c("d", "g", "md", "or", "rr", "nnt", "r", "z", "logvr", "logcvr", "irr"),
  type_of_measure = c("natural", "natural+converted"),
  name = "mcv_data_extraction",
  extension = c("data.frame", ".txt", ".csv", ".xlsx"),
  verbose = TRUE
)
}
\arguments{
\item{measure}{Target effect size measure (one of the 11 available in metaConvert). Default is "all".}

\item{type_of_measure}{One of "natural+converted" or "natural" (see details).}

\item{name}{Name of the file created}

\item{extension}{Extension of the file created. Most common are ".xlsx", ".csv" or ".txt". It is also possible to generate an R dataframe object by using the "data.frame" extension.}

\item{verbose}{logical variable indicating whether some information should be printed (e.g., the location where the sheet is created when using ".xlsx", ".csv" or ".txt" extensions)}
}
\value{
This function returns a data extraction sheet that contains all the information
necessary to estimate any effect size using the metaConvert tools.
}
\description{
Data extraction sheet generator
}
\details{
This function generates, on your computer, a data extraction sheet that contains the name of columns
that can be used by our tools to estimate various effect size measures.

If you select a specific measure (e.g., \code{measure = "g"}), you will be presented only with most common
information allowing to estimate this measure (e.g., you will not be provided with columns for contigency
tables if you request a data extraction sheet for \code{measure = "g"}).
\subsection{Measure}{

You can specify a specific effect size measures (among those available in the \code{\link{metaConvert-package}}).
Doing this, the data extraction sheet will contain only the columns of the input data allowing \strong{a natural estimation
of the effect size measure}. For example, if you request \code{measure="d"} the data extraction
sheet will not contain the columns for the contingency table since, although the \code{\link{convert_df}}
function allows you to \strong{convert} a contingency table into a "d", this requires to convert the "OR"
that is naturally estimated from the contingency table into a "d".

This table is designed to be used in combination with tables showing the combination of input data
leading to estimate each of the effect size measures (https://metaconvert.org/html/input.html)
}

\subsection{Extension}{

You can export a file in various formats outside R
(by indicating, for example, ".txt", ".xlsx", or ".csv") in the \code{extension} argument.
You can also visualise this dataset directly in R by setting \code{extension = "data.frame"}.
}
}
\examples{
data_extraction_sheet(measure = "md", extension = "data.frame")
}
