% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGEfit.R
\name{metaGE.fit}
\alias{metaGE.fit}
\title{Meta-analysis procedure: Fixed or Random effect.}
\usage{
metaGE.fit(Data, MatCorr, Method, NA.omit = TRUE, DropZScores = FALSE)
}
\arguments{
\item{Data}{A dataset containing the estimated marker effect and its associated pvalue of each marker (in rows) in each environment (in columns), as obtained from metaGE.collect.}

\item{MatCorr}{The inter-environments correlation matrix. Can be computed using metaGE.cor.}

\item{Method}{A string specifying the method to be performed: either 'Fe' or 'Re'.}

\item{NA.omit}{A boolean specifying whether the markers with some NA values should be removed. (TRUE by default)}

\item{DropZScores}{A boolean specifying whether the Zscores should be dropped from the dataset or not.(FALSE by default)}
}
\value{
The dataset Data with supplementary  columns:
\itemize{
\item Mu: Estimation of Mu,
\item Tau: Estimation of Tau, the heterogeneity,
\item Pvalue: The Pvalue of the test,
\item the Zscores for each environment if DropLocalScores = FALSE.
}
}
\description{
Quantitative trait loci detection via Fixed or Random effect meta-analysis GWAS procedure.
}
\details{
Different tests may be performed:
\itemize{
\item Fixed Effect (Fe), to identify markers with a stable effect across environments.
\item Random Effect (Re), to identify markers whose effects may be unstable across environments.
}
}
\examples{
require(dplyr)
# Import the data
data("metaData")

# Compute the inter-environment correlation matrix
matCorr <- metaGE.cor(metaData, Threshold = 0.8)

# Fixed Effect
FeDF <- metaGE.fit(metaData, matCorr, Method = "Fe")
head(FeDF \%>\% select(CHR, POS, MARKER, Mu, Tau, PVALUE))

# Random Effect
ReDF <- metaGE.fit(metaData, matCorr, Method = "Re")
head(ReDF \%>\% select(CHR, POS, MARKER, Mu, Tau, PVALUE))

}
