% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_documentation.R
\docType{data}
\name{its1_ex_data}
\alias{its1_ex_data}
\title{Example of ITS1 fungal data}
\format{An object of type \code{\link{taxmap}}}
\usage{
its1_ex_data
}
\description{
A dataset containing information from 170 Chytridiomycota ITS sequences from the ITS1 reference database.
}
\examples{
\dontrun{

file_path <- system.file("extdata", "its1_chytridiomycota_hmm.fasta", package = "metacoder")
sequences <- ape::read.FASTA(file_path)
its1_ex_data <- extract_taxonomy(sequences,
                                 regex = "^(.*)\\\\|(.*)\\\\|tax_id:(.*)\\\\|(.*)$",
                                 key = c("obs_id", taxon_name = "taxon_info",
                                         "taxon_id", description = "obs_info"),
                                 database = "ncbi")
}

}
\keyword{datasets}
