% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_documentation.R
\docType{data}
\name{rdp_ex_data}
\alias{rdp_ex_data}
\title{Example of RDP Archea data}
\format{An object of type \code{\link{taxmap}}}
\source{
\url{http://rdp.cme.msu.edu/}
}
\usage{
rdp_ex_data
}
\description{
A dataset containing information from 400 Archaea 16S sequences from the RDP reference database.
}
\examples{
\dontrun{

file_path <- system.file("extdata", "rdp_current_Archaea_unaligned.fa", package = "metacoder")
sequences <- ape::read.FASTA(file_path)
rdp_ex_data <- extract_taxonomy(sequences,
                                regex = "^(.*?) (.*)\\\\tLineage=(.*)",
                                key = c(id = "obs_info", description = "obs_info", "class"),
                                class_regex = "(.+?);(.*?);",
                                class_key = c("name", "taxon_info"))
}

}
\keyword{datasets}
