% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_builder.R
\name{spec_type_to_ds_vars}
\alias{spec_type_to_ds_vars}
\title{Spec to ds_vars}
\usage{
spec_type_to_ds_vars(
  doc,
  cols = c(dataset = "[D|d]ataset|[D|d]omain", variable =
    "[V|v]ariable [[N|n]ame]?|[V|v]ariables?", order =
    "[V|v]ariable [O|o]rder|[O|o]rder", keep = "[K|k]eep|[M|m]andatory"),
  key_seq_sep_sheet = TRUE,
  key_seq_cols = c(dataset = "Dataset", key_seq = "Key Variables"),
  sheet = "[V|v]ar|Datasets"
)
}
\arguments{
\item{doc}{Named list of datasets @seealso \code{\link[=read_all_sheets]{read_all_sheets()}} for exact
format}

\item{cols}{Named vector of column names. The column names can be regular
expressions for more flexibility. But, the names must follow the given
pattern}

\item{key_seq_sep_sheet}{A boolean to indicate if the key sequence is on a
separate sheet. If set to false add the key_seq column name to the \code{cols}
vector.}

\item{key_seq_cols}{names vector to get the key_sequence for each dataset}

\item{sheet}{Regular expression for the sheet names}
}
\value{
a dataset formatted for the metacore object
}
\description{
Creates the ds_vars from a list of datasets (optionally filtered by the sheet
input). The named vector \code{cols} is used to determine which is the correct
sheet and renames the columns
}
\seealso{
Other spec builders: 
\code{\link{spec_type_to_codelist}()},
\code{\link{spec_type_to_derivations}()},
\code{\link{spec_type_to_ds_spec}()},
\code{\link{spec_type_to_value_spec}()},
\code{\link{spec_type_to_var_spec}()}
}
\concept{spec builders}
