% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure_scatterPlot.R
\name{figure_scatterPlot}
\alias{figure_scatterPlot}
\title{Detect and display all scatter plot objects.}
\usage{
figure_scatterPlot(file = file.choose(), binary_threshold = 0.6,
  binary_point_fill = FALSE, binary_point_tolerance = 2,
  axis_thickness = 5, axis_sensitivity = 0.2, axis_X_color = "#00ABAB",
  X_min = 40, X_max = 140, axis_Y_color = "#B0D36A", Y_min = 40,
  Y_max = 140, point_sensitivity = 0.2, point_shape = "circle",
  point_size = 3, point_color = "#0098B2", ignore = FALSE)
}
\arguments{
\item{file}{The file name and location of a scatter plot figure.  Prompts
for file name if none is explicitly called.}

\item{binary_threshold}{A proportion from zero to one designating the 
gray-scale threshold to convert pixels into black or white.  Pixel
intensities below the proportion will be converted to black, and those 
above white.}

\item{binary_point_fill}{If \code{TRUE} then fills empty points/symbols
in figure.}

\item{binary_point_tolerance}{An integer used to designate the size of the 
points to the fill.  Increase value to better fill empty points.}

\item{axis_thickness}{An integer used to designate the thickness of the 
axis lines on a figure.  Close alignment to the thickness of the axis
on a figure will improve axis detection.}

\item{axis_sensitivity}{A value designating the sensitivity of identifying 
straight lines on figure.  A smaller number results in a higher 
sensitivity to identify axes.}

\item{axis_X_color}{The color to paint the detected X-axis.}

\item{X_min}{The minimum X value displayed on the X-axis (used to scale
detected data points).}

\item{X_max}{The maximum X value displayed on the X-axis (used to scale
detected data points).}

\item{axis_Y_color}{The color to paint the detected Y-axis.}

\item{Y_min}{The minimum Y value displayed on the Y-axis (used to scale
detected data points).}

\item{Y_max}{The maximum Y value displayed on the Y-axis (used to scale
detected data points).}

\item{point_sensitivity}{A value designating the sensitivity of identifying 
unique points that overlap.  A smaller number results in a higher 
sensitivity to split overlapping points; a larger number will extract only
a single point from a cluster of overlapping points.}

\item{point_shape}{The shape of points on figure: can be \code{"circle"},
\code{"square"}, or \code{"diamond"}.  If these options do not fit the
shape found in a figure, use the option that best approximates that
shape.}

\item{point_size}{An integer used to designate the size of the points on
the figure.  Close alignment to the size of the points on a figure will
improve point detection.  See \code{EBImage} package to help determine which
size to use.}

\item{point_color}{The color to paint the detected scatter plot points.}

\item{ignore}{When \code{TRUE} does not display painted image, only 
returns painted image EBImage object.}
}
\value{
A data frame with detected points.
}
\description{
Automated detection of the X-axis, Y-axis, and points on a scatter-plot
figure image.  The default returns these detected objects as an 
\code{EBImage} raster image, as well as the estimated effect size (correlation
coefficient or r) of the data within the scatter-plot.
}
