% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uvmeta.r
\name{dplot.uvmeta}
\alias{dplot.uvmeta}
\title{Plot the prior and posterior distribution of a meta-analysis model}
\usage{
\method{dplot}{uvmeta}(x, par, distr_type, plot_type = "dens", ...)
}
\arguments{
\item{x}{An object of class \code{"uvmeta"}}

\item{par}{Character string to specify for which parameter a plot should be generated. Options are \code{"mu"} 
(mean of the random effects model) and \code{"tau"} (standard deviation of the random effects model).}

\item{distr_type}{Character string to specify whether the prior distribution (\code{"prior"}) or 
posterior distribution (\code{"posterior"}) should be displayed.}

\item{plot_type}{Character string to specify whether a density plot (\code{"dens"}) or 
histogram (\code{"hist"}) should be displayed.}

\item{\ldots}{Additional arguments which are currently not used}
}
\value{
An object of class \code{ggplot}
}
\description{
Function to generate plots for the prior and posterior distribution of a Bayesian meta-analysis.
}
\examples{
\dontrun{
data(Roberts)

fit <- with(Roberts, uvmeta(r=SDM, r.se=SE, method="BAYES"))

dplot(fit)
dplot(fit, distr_type = "posterior")
dplot(fit, par = "tau", distr_type = "prior")
dplot(fit, plot_type = "hist")
} 

}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{density}
\keyword{distribution}
\keyword{meta-analysis}
