% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fat.r
\name{plot.fat}
\alias{plot.fat}
\title{Display results from the funnel plot asymmetry test}
\usage{
\method{plot}{fat}(
  x,
  ref,
  confint = TRUE,
  confint.level = 0.1,
  confint.col = "skyblue",
  confint.alpha = 0.5,
  confint.density = NULL,
  xlab = "Effect size",
  add.pval = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{fat}}

\item{ref}{A numeric value indicating the fixed or random effects summary estimate. If no value is provided
then it will be retrieved from a fixed effects meta-analysis (if possible).}

\item{confint}{A logical indicator. If \code{TRUE}, a confidence interval will be displayed for the estimated
regression model (based on a Student-T distribution)}

\item{confint.level}{Significance level for constructing the confidence interval.}

\item{confint.col}{The color for filling the confidence interval. Choose \code{NA} to leave polygons unfilled. 
If \code{confint.density} is specified with a positive value this gives the color of the shading lines.}

\item{confint.alpha}{A numeric value between 0 and 1 indicating the opacity for the confidence region.}

\item{confint.density}{The density of shading lines, in lines per inch. The default value of \code{NULL} means 
that no shading lines are drawn. A zero value of density means no shading nor filling whereas negative values 
and \code{NA} suppress shading (and so allow color filling).}

\item{xlab}{A title for the x axis}

\item{add.pval}{Logical to indicate whether a P-value should be added to the plot}

\item{...}{Additional arguments.}
}
\description{
Generates a funnel plot for a fitted \code{fat} object.
}
\examples{
data(Fibrinogen)
b <- log(Fibrinogen$HR)
b.se <- ((log(Fibrinogen$HR.975) - log(Fibrinogen$HR.025))/(2*qnorm(0.975)))
n.total <- Fibrinogen$N.total

# A very simple funnel plot
plot(fat(b=b, b.se=b.se), xlab = "Log hazard ratio")

# Plot the funnel for an alternative test
plot(fat(b=b, b.se=b.se, n.total=n.total, method="M-FIV"), xlab = "Log hazard ratio")


}
\author{
Thomas Debray <thomas.debray@gmail.com>

Frantisek Bartos <f.bartos96@gmail.com>
}
