% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_snf.R
\name{snf_scheme}
\alias{snf_scheme}
\alias{two_step_merge}
\alias{domain_merge}
\alias{individual}
\title{SNF schemes}
\usage{
two_step_merge(
  dl,
  k = 20,
  alpha = 0.5,
  t = 20,
  cnt_dist_fn,
  dsc_dist_fn,
  ord_dist_fn,
  cat_dist_fn,
  mix_dist_fn,
  weights_row
)

domain_merge(
  dl,
  cnt_dist_fn,
  dsc_dist_fn,
  ord_dist_fn,
  cat_dist_fn,
  mix_dist_fn,
  weights_row,
  k,
  alpha,
  t
)

individual(
  dl,
  k = 20,
  alpha = 0.5,
  t = 20,
  cnt_dist_fn,
  dsc_dist_fn,
  ord_dist_fn,
  cat_dist_fn,
  mix_dist_fn,
  weights_row
)
}
\arguments{
\item{dl}{A nested list of input data from \code{data_list()}.}

\item{k}{k hyperparameter.}

\item{alpha}{alpha/eta/sigma hyperparameter.}

\item{t}{SNF number of iterations hyperparameter.}

\item{cnt_dist_fn}{distance metric function for continuous data.}

\item{dsc_dist_fn}{distance metric function for discrete data.}

\item{ord_dist_fn}{distance metric function for ordinal data.}

\item{cat_dist_fn}{distance metric function for categorical data.}

\item{mix_dist_fn}{distance metric function for mixed data.}

\item{weights_row}{data frame row containing feature weights.}
}
\description{
These functions manage the way in which input data frames are passed into
SNF to yield a final fused network.
}
\details{
individual: The "vanilla" scheme - does distance matrix conversions of each input
data frame separately before a single call to SNF fuses them into the final
fused network.

domain_merge: Given a data list, returns a new data list where all data objects of
a particlar domain have been concatenated.

two_step_merge: Individual data frames into individual similarity matrices into one fused
network per domain into one final fused network.
}
\keyword{internal}
