% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umbrella_GUI.R
\name{umbrella.gui}
\alias{umbrella.gui}
\title{Graphical User Interface for conducting an umbrella review}
\usage{
umbrella.gui()
}
\value{
The \code{umbrella.gui()} function returns several elements including \tabular{ll}{
\code{csv} \tab a csv file containing the results of the umbrella review.\cr
\tab \cr
\code{pdf} \tab a pdf file containing the plot of the results (only if requested, i.e., the \code{plot_results}\cr
\tab argument is set as TRUE).\cr
\tab \cr
\code{html} \tab an HTML file containing the results of the umbrella review.\cr
}
}
\description{
The \code{umbrella.gui} function allows to perform an umbrella review in R with a graphical user interface and to generate results outside of R.
}
\details{
This function implicitly calls the \code{view.errors.umbrella()} to check the formatting of the data,
the \code{umbrella()} function to perform calculations, the \code{add.evidence()} function to stratify evidence (limited to "Ioannidis" and "GRADE" classifications for now)
and the \code{forest()} function to generate a visual representation of the results.

To use this function:
\itemize{
\item The first step is to type \code{umbrella.gui()} in the console. This will open a pop-up window.
\item The second step is to load a well-formatted dataset (stored in an excel file) by clicking on the button at the right of the "Excel file" label. An exploratory window will open, allowing to select the file that should be uploaded.
\item The third step is to select the folder where the results will be exported. Again, this can be achieved by clicking on the button at the right of the "Output folder" label, and selecting the appropriate folder thanks to the exploratory window.
\item Last, the classification that should be used for stratifying the evidence has to be selected. For now, "Ioannidis" and "GRADE" classifications are available.
}
}
\examples{
if(interactive()){
### open the GUI
umbrella.gui()
}
}
\seealso{
\code{\link{umbrella}()}\cr
\code{\link{add.evidence}()}\cr
\code{\link{summary.umbrella}()}
}
