% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/prepData.R
\name{prepData}
\alias{prepData}
\title{Prep data to test phylogenetic community structure metrics}
\usage{
prepData(tree, picante.cdm, optional.dists = NULL)
}
\arguments{
\item{tree}{Phylo object.}

\item{picante.cdm}{A picante-style community data matrix with sites as rows, and
species as columns}

\item{optional.dists}{A symmetric distance matrix can be directly supplied. This option
is experimental. Behavior depends on metric being used. If the metric in question
relies on the phylogenetic distance matrix from a call to cophenetic(tree), then this
optional distance matrix will be inserted instead.}
}
\value{
An object of class metrics.input
}
\description{
Given a phylo object, and a picante-style community data matrix (sites are rows,
species are columns), prepare data for analysis.
}
\details{
Returns a named list with three elements: the original phylogenetic tree
phylogenetic distances among species, and the original picante-style CDM.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

prepped <- prepData(tree, cdm)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

