% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summCorrs.R
\name{summCorrs}
\alias{summCorrs}
\title{Summarize correlations among metrics over a result from a varyX function}
\usage{
summCorrs(vary.results, exclude, return.raw = FALSE,
  cor.method = "spearman")
}
\arguments{
\item{vary.results}{Results from any of the varyX (e.g., varyAbundance) functions.}

\item{exclude}{Results columns to exclude from correlation. For instance, with alpha
metrics, one would want to, at the minimum, exclude the plot name column.}

\item{return.raw}{Default is FALSE. Whether to return the raw correlation coefficients
between the metrics for each element from vary.results, or whether to summarize the
correlations by their mean per parameter set from vary.results.}

\item{cor.method}{Default is "spearman", but takes any of the other options from the
base cor function.}
}
\value{
If return.raw is set to FALSE, returns a list of matrices, one for each set
of parameters in vary.results, summarizing the mean correlation coefficients between
each pairwise metric correlation. If return.raw is set to TRUE, returns a list of
lists, one for each set of parameters. Each of these lists is the length of the number
of iterations in vary.results. Each element in the list is a matrix of pairwise metric
correlations.
}
\description{
Takes the results of one of the varyX functions, and calculates the correlations among
metrics, returning either the raw or summarized correlations.
}
\details{
Not a well tested function.
}
\examples{
#below not run for timing issues on CRAN
#system.time(vSize <- varyX(alpha=TRUE, tree.size=c(40, 50), richness=20:30, delta=1,
#abundances=round(rlnorm(5000, meanlog=2, sdlog=1)) + 1, iterations=2, cores="seq"))

#test <- summCorrs(vSize, exclude=c("plot", "richness"))
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
