% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ue.R
\name{Ue}
\alias{Ue}
\title{Lack of Consistency (Ue)}
\usage{
Ue(data = NULL, obs, pred, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric}.
The Ue estimates the proportion of the total sum of squares related to the
random error (unsystematic error or variance) following the sum of squares decomposition
suggested by Smith and Rose (1995) also known as Theil's partial inequalities.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\description{
It estimates the Ue component from the sum of squares decomposition
described by Smith & Rose (1995).
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
Ue(obs = X, pred = Y)
}
}
\references{
Smith & Rose (1995).
Model goodness-of-fit analysis using regression and related techniques.
\emph{Ecol. Model. 77, 49–64.} \doi{10.1016/0304-3800(93)E0074-D}
}
