% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_apsim_db.R
\name{import_apsim_db}
\alias{import_apsim_db}
\title{Import SQLite databases generated by APSIM NextGen}
\usage{
import_apsim_db(filename = "", folder = ".", value = "report", simplify = TRUE)
}
\arguments{
\item{filename}{file name including the file extension ("*.db"), as a string ("").}

\item{folder}{source folder/directory containing the file, as a string ("").}

\item{value}{either \sQuote{report}, \sQuote{all} (list) or user-defined for a specific report.}

\item{simplify}{if TRUE will attempt to simplify multiple reports into a single data.frame.
If FALSE it will return a list.}
}
\value{
An object of class \code{data.frame}, but it depends on the argument \sQuote{value} above
}
\description{
Imports data from SQLite databases (*.db)
}
\note{
Adapted from apsimx to maintain compatibility. For reference, we also recommend
to check and use the function apsimx::read_apsimx() as an alternative.
Source: https://github.com/femiguez/apsimx by F. Miguez.
}
\examples{
\donttest{
## See [documentation](https://adriancorrendo.github.io/metrica/index.html)
}
}
\seealso{
\code{\link[apsimx]{read_apsimx}}
}
