% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm-utils.R
\name{glm_IPTW}
\alias{glm_IPTW}
\title{IPTW GLM, Inverse Probaibilty of Treatment Weighted GLM}
\usage{
glm_IPTW(
  formula,
  data,
  treat.model = NULL,
  family = binomial(),
  id = NULL,
  weights = NULL,
  estpr = 1,
  pi0 = 0.5,
  ...
)
}
\arguments{
\item{formula}{for glm}

\item{data}{data frame for risk averaging}

\item{treat.model}{propensity score model (binary or multinomial)}

\item{family}{of glm (logistic regression)}

\item{id}{cluster id for standard errors}

\item{weights}{may be given, and then uses weights*w(A) as the weights}

\item{estpr}{to estimate propensity scores and get infuence function contribution to uncertainty}

\item{pi0}{fixed simple weights}

\item{...}{arguments for glm call}
}
\description{
Fits GLM model with treatment weights \deqn{ w(A)= \sum_a I(A=a)/P(A=a|X) }, computes
standard errors via influence functions that are returned as the IID argument. 
Propensity scores are fitted using either logistic regression (glm) or the multinomial model (mlogit) when more
than two categories for treatment. The treatment needs to be a factor and is identified on the rhs
of the "treat.model".
}
\details{
Also works with cluster argument.
}
\author{
Thomas Scheike
}
