% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{gev.pll}
\alias{gev.pll}
\title{Profile log-likelihood for the generalized extreme value distribution}
\usage{
gev.pll(
  psi,
  param = c("loc", "scale", "shape", "quant", "Nmean", "Nquant"),
  mod = "profile",
  dat,
  N = NULL,
  p = NULL,
  q = NULL,
  correction = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{psi}{parameter vector over which to profile (unidimensional)}

\item{param}{string indicating the parameter to profile over}

\item{mod}{string indicating the model, one of \code{profile}, \code{tem} or \code{modif}.See \bold{Details}.}

\item{dat}{sample vector}

\item{N}{size of block over which to take maxima. Required only for \code{param} \code{Nmean} and \code{Nquant}.}

\item{p}{tail probability. Required only for \code{param} \code{quant}.}

\item{q}{probability level of quantile. Required only for \code{param} \code{Nquant}.}

\item{correction}{logical indicating whether to use \code{spline.corr} to smooth the tem approximation.}

\item{plot}{logical; should the profile likelihood be displayed? Default to \code{TRUE}}

\item{...}{additional arguments such as output from call to \code{Vfun} if \code{mode='tem'}.}
}
\value{
a list with components
\itemize{
\item \code{mle}: maximum likelihood estimate
\item \code{psi.max}: maximum profile likelihood estimate
\item \code{param}: string indicating the parameter to profile over
\item \code{std.error}: standard error of \code{psi.max}
\item \code{psi}: vector of parameter \eqn{\psi} given in \code{psi}
\item \code{pll}: values of the profile log likelihood at \code{psi}
\item \code{maxpll}: value of maximum profile log likelihood
}


In addition, if \code{mod} includes \code{tem}
\itemize{
\item \code{normal}: maximum likelihood estimate and standard error of the interest parameter \eqn{\psi}
\item \code{r}: values of likelihood root corresponding to \eqn{\psi}
\item \code{q}: vector of likelihood modifications
\item \code{rstar}: modified likelihood root vector
\item \code{rstar.old}: uncorrected modified likelihood root vector
\item \code{tem.psimax}: maximum of the tangent exponential model likelihood
}
In addition, if \code{mod} includes \code{modif}
\itemize{
\item \code{tem.mle}: maximum of tangent exponential modified profile log likelihood
\item \code{tem.profll}: values of the modified profile log likelihood at \code{psi}
\item \code{tem.maxpll}: value of maximum modified profile log likelihood
\item \code{empcov.mle}: maximum of Severini's empirical covariance modified profile log likelihood
\item \code{empcov.profll}: values of the modified profile log likelihood at \code{psi}
\item \code{empcov.maxpll}: value of maximum modified profile log likelihood
}
}
\description{
This function calculates the profile likelihood along with two small-sample corrections
based on Severini's (1999) empirical covariance and the Fraser and Reid tangent exponential
model approximation.
}
\details{
The two additional \code{mod} available are \code{tem}, the tangent exponential model (TEM) approximation and
\code{modif} for the penalized profile likelihood based on \eqn{p^*} approximation proposed by Severini.
For the latter, the penalization is based on the TEM or an empirical covariance adjustment term.
}
\examples{
\dontrun{
set.seed(123)
dat <- rgev(n = 100, loc = 0, scale = 2, shape = 0.3)
gev.pll(psi = seq(0,0.5, length = 50), param = 'shape', dat = dat)
gev.pll(psi = seq(-1.5, 1.5, length = 50), param = 'loc', dat = dat)
gev.pll(psi = seq(10, 40, length = 50), param = 'quant', dat = dat, p = 0.01)
gev.pll(psi = seq(12, 100, length = 50), param = 'Nmean', N = 100, dat = dat)
gev.pll(psi = seq(12, 90, length = 50), param = 'Nquant', N = 100, dat = dat, q = 0.5)
}
}
\references{
Fraser, D. A. S., Reid, N. and Wu, J. (1999), A simple general formula for tail probabilities for frequentist and Bayesian inference. \emph{Biometrika}, \bold{86}(2), 249--264.

Severini, T. (2000) Likelihood Methods in Statistics. Oxford University Press. ISBN 9780198506508.

Brazzale, A. R., Davison, A. C. and Reid, N. (2007) Applied asymptotics: case studies in small-sample statistics. Cambridge University Press, Cambridge. ISBN 978-0-521-84703-2
}
