# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Random variate generation for Dirichlet distribution on \eqn{S_{d}}{Sd}
#'
#' A function to sample Dirichlet random variables, based on the representation as ratios of Gamma.
#' Note that the RNG will generate on the full simplex and the sum to one constraint is respected
#' here
#'
#' @param n sample size
#' @param alpha vector of parameter
#' @param normalize boolean. If \code{FALSE}, the function returns Gamma variates with parameter \code{alpha}.
#'
#' @return sample of dimension \code{d} (size of alpha) from the Dirichlet distribution.
#' @examples rdir(n=100, alpha=c(0.5,0.5,2),TRUE)
#' rdir(n=100, alpha=c(3,1,2),FALSE)
rdir <- function(n, alpha, normalize = TRUE) {
    .Call('mev_rdir', PACKAGE = 'mev', n, alpha, normalize)
}

#' Multivariate Normal distribution sampler
#'
#' Sampler derived using the eigendecomposition of the covariance
#' matrix \code{Sigma}. The function uses the Armadillo random normal generator
#'
#' @param n sample size
#' @param mu mean vector. Will set the dimension
#' @param Sigma a square covariance matrix, of same dimension as \code{mu}.
#' No sanity check is performed to validate that the matrix is p.s.d., so use at own risk
#'
#' @return an \code{n} sample from a multivariate Normal distribution
#' @examples
#' mvrnorm(n=10, mu=c(0,2), Sigma=diag(2))
mvrnorm <- function(n, mu, Sigma) {
    .Call('mev_mvrnorm', PACKAGE = 'mev', n, mu, Sigma)
}

#' Multivariate Normal distribution sampler (Rcpp version), derived using the eigendecomposition
#' of the covariance matrix Sigma. The function utilizes the arma random normal generator
#'
#' @param n sample size
#' @param mu mean vector. Will set the dimension
#' @param Sigma covariance matrix, of same dimension as mu (and square matrix).
#' No sanity check is performed to validate that the matrix is p.s.d., so use at own risk
#'
#' @return an n sample from a multivariate Normal distribution
#'
.mvrnorm_arma <- function(n, Mu, Xmat) {
    .Call('mev_mvrnorm_arma', PACKAGE = 'mev', n, Mu, Xmat)
}

#' Generate from logistic \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal function scaled by a Frechet variate
#'
#' @param d dimension of the 1-sample
#' @param index index of the location. An integer in {0, ..., \eqn{d-1}}
#' @param theta a one-dimensional parameter for the logistic model, strictly greater than 1.
#'
#' @return a \code{d}-vector from \eqn{P_x}
.rPlog <- function(d, index, theta) {
    .Call('mev_rPlog', PACKAGE = 'mev', d, index, theta)
}

#' Generate from negative logistic \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal function scaled by a Frechet variate
#'
#' @param d dimension of the 1-sample
#' @param index index of the location. An integer in {0, ..., \eqn{d-1}}
#' @param theta a one-dimensional parameter for the negative logistic model
#'
#' @return a \code{d}-vector from \eqn{P_x}
.rPneglog <- function(d, index, theta) {
    .Call('mev_rPneglog', PACKAGE = 'mev', d, index, theta)
}

#' Generate from extremal Dirichlet \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal functions from a Dirichlet mixture
#'
#' @param d dimension of the 1-sample
#' @param index index of the location. An integer in {0, ..., \eqn{d-1}}
#' @param alpha a \eqn{d \times n} dimensional vector of positive parameter values for the Dirichlet vector
#' @param weight a \code{m} vector of mixture weights, which sum to 1
#' @return a \code{d}-vector from \eqn{P_x}
.rPdirmix <- function(d, index, alpha, weight) {
    .Call('mev_rPdirmix', PACKAGE = 'mev', d, index, alpha, weight)
}

#' Generate from bilogistic \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal functions
#'
#' @param d dimension of the 1-sample
#' @param index index of the location. An integer in {0, ..., \eqn{d-1}}
#' @param alpha a \eqn{d} dimensional vector of positive parameter values for the Dirichlet vector
#' @return a \code{d}-vector from \eqn{P_x}
.rPbilog <- function(d, index, alpha) {
    .Call('mev_rPbilog', PACKAGE = 'mev', d, index, alpha)
}

#' Generate from extremal Student-t \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal function
#'
#' @param index index of the location. An integer in {0, ..., \eqn{d-1}}
#' @param Sigma a positive semi-definite covariance matrix with unit variance
#' @param al the alpha parameter in Proposition 7. Corresponds to degrees of freedom - 1
#'
#' @return a \code{d}-vector from \eqn{P_x}
.rPexstud <- function(index, sigma, al) {
    .Call('mev_rPexstud', PACKAGE = 'mev', index, sigma, al)
}

#' Generate from extremal Husler-Reiss distribution (Brown-Resnick) \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal function
#'
#' @param index index of the location. An integer in {0, ..., \eqn{d-1}}
#' @param Sigma a positive semi-definite covariance matrix
#'
#' @return a \code{d}-vector from \eqn{P_x}
.rPHuslerReiss <- function(index, Sigma) {
    .Call('mev_rPHuslerReiss', PACKAGE = 'mev', index, Sigma)
}

#' Generate from Smith model (moving maxima) \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal function
#'
#' @param index index of the location. An integer in {0, ..., \eqn{d-1}}
#' @param Sigma a positive semi-definite covariance matrix
#' @param loc location matrix
#'
#' @return a \code{d}-vector from \eqn{P_x}
.rPSmith <- function(index, Sigma, loc) {
    .Call('mev_rPSmith', PACKAGE = 'mev', index, Sigma, loc)
}

#' Generate from extremal Dirichlet \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal functions from the Dirichlet model of
#' Coles and Tawn.
#'
#' @param d dimension of the 1-sample
#' @param index index of the location. An integer in {0, ..., \eqn{d-1}}
#' @param alpha a \eqn{d} dimensional vector of positive parameter values for the Dirichlet vector, or
#' \eqn{d+1} if the last entry is the index of regular variation of the model, a constant in \code{(0, 1]}
#' @param irv should the usual model (\code{FALSE}) or the general scaled version (\code{TRUE}) be used
#'
#' @return a \code{d}-vector from \eqn{P_x}
.rPdir <- function(d, index, alpha, irv = FALSE) {
    .Call('mev_rPdir', PACKAGE = 'mev', d, index, alpha, irv)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the logistic model
#'
#' Simulation algorithm of Dombry et al. (2015)
#'
#' @param n sample size
#' @param theta a one-dimensional parameter
#'
#' @references Dombry, Engelke and Oesting (2015). Exact simulation of max-stable
#' processes, \emph{arXiv:1506.04430v1}, 1--24.
#'
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rlogspec <- function(n, d, theta) {
    .Call('mev_rlogspec', PACKAGE = 'mev', n, d, theta)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the negative logistic model
#'
#' Simulation algorithm of Dombry et al. (2015)
#'
#' @param n sample size
#' @param theta a one-dimensional parameter
#'
#' @references Dombry, Engelke and Oesting (2015). Exact simulation of max-stable
#' processes, \emph{arXiv:1506.04430v1}, 1--24.
#'
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rneglogspec <- function(n, d, theta) {
    .Call('mev_rneglogspec', PACKAGE = 'mev', n, d, theta)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the Dirichlet mixture model
#'
#' Simulation algorithm of Dombry et al. (2015)
#'
#' @param n sample size
#' @param d dimension of the 1-sample
#' @param alpha a \eqn{d \times n} dimensional vector of positive parameter values for the Dirichlet vector
#' @param weight a \code{m} vector of mixture weights, which sum to 1
#'
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rdirmixspec <- function(n, d, alpha, weight) {
    .Call('mev_rdirmixspec', PACKAGE = 'mev', n, d, alpha, weight)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the bilogistic model
#'
#' Simulation algorithm of Boldi (2009) for the bilogistic model
#'
#' @param n sample size
#' @param alpha vector of parameter of dimension \code{d}
#'
#' @references Boldi (2009). A note on the representation of parametric models
#' for multivariate extremes. \emph{Extremes} \bold{12}, 211--218.
#'
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rbilogspec <- function(n, alpha) {
    .Call('mev_rbilogspec', PACKAGE = 'mev', n, alpha)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the extremal Student model
#'
#' @param index index of the location. An integer in {0, ..., \eqn{d-1}}
#' @param Sigma a positive semi-definite covariance matrix with unit variance
#' @param al the alpha parameter in Proposition 7. Corresponds to degrees of freedom - 1
#'
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rexstudspec <- function(n, sigma, al) {
    .Call('mev_rexstudspec', PACKAGE = 'mev', n, sigma, al)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the Brown-Resnick (or Husler-Reiss) model
#'
#' Simulation algorithm of Dombry et al. (2015)
#'
#' @param n sample size
#' @param Sigma \code{d}-dimensional covariance matrix
#'
#' @references Dombry, Engelke and Oesting (2015). Exact simulation of max-stable
#' processes, \emph{arXiv:1506.04430v1}, 1--24.
#'
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rhrspec <- function(n, Sigma) {
    .Call('mev_rhrspec', PACKAGE = 'mev', n, Sigma)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the Smith model (moving maxima)
#'
#' Simulation algorithm of Dombry et al. (2015)
#'
#' @param n sample size
#' @param Sigma \code{d}-dimensional covariance matrix
#' @param loc location matrix
#'
#' @references Dombry, Engelke and Oesting (2015). Exact simulation of max-stable
#' processes, \emph{arXiv:1506.04430v1}, 1--24.
#'
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rsmithspec <- function(n, Sigma, loc) {
    .Call('mev_rsmithspec', PACKAGE = 'mev', n, Sigma, loc)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the extremal Dirichlet
#' model
#'
#' This model was introduced in Coles and Tawn (1991); the
#' present method uses the simulation algorithm of Boldi (2009) for the extremal Dirichlet model
#'
#' @param n sample size
#' @param d dimension of sample
#' @param alpha vector of Dirichlet parameters of dimension \code{d}, or \eqn{d+1} vector with the \code{d} Dirichlet parameters and an index of regular variation in \eqn{[0, 1]}
#' @param rho index of regular variation
#' @param irv should the usual model (\code{FALSE}) or the general scaled version (\code{TRUE}) be used
#'
#' @references Boldi (2009). A note on the representation of parametric models
#' for multivariate extremes. \emph{Extremes} \bold{12}, 211--218.
#'
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rdirspec <- function(n, d, alpha, irv = FALSE) {
    .Call('mev_rdirspec', PACKAGE = 'mev', n, d, alpha, irv)
}

#' Multivariate extreme value distribution sampling algorithm
#' corresponding to Algorithm 1 in Dombry, Engelke and Oesting (2015),
#' using the formulation of the Dirichlet mixture of Coles and Tawn (1991)
#' as described and derived in Boldi (2009) for the bilogistic and extremal
#' Dirichlet model. Models currently implemented include logistic, negative
#' logistic, extremal Dirichlet and bilogistic MEV.
#'
#' @param n sample size
#' @param d dimension of the multivariate distribution
#' @param param a vector of parameters
#' @param model integer, currently ranging from 1 to 8, corresponding respectively to
#' (1) \code{log}, (2) \code{neglog}, (3) \code{dirmix}, (4) \code{bilog},
#' (5) \code{extstud}, (6) \code{hr}, (7) \code{ct} and (8) \code{smith}.
#' @param Sigma covariance matrix for Husler-Reiss, Smith and extremal student. Default for compatibility
#' @param loc matrix of location for Smith model.
#'
#' @return a \code{n} by \code{d} matrix containing the sample
.rmevA1 <- function(n, d, param, model, Sigma, loc) {
    .Call('mev_rmevA1', PACKAGE = 'mev', n, d, param, model, Sigma, loc)
}

#' Multivariate extreme value distribution sampling algorithm
#' corresponding to Algorithm 2 in Dombry, Engelke and Oesting (2015)
#'
#' Models currently implemented include logistic and negative logistic, sampling
#' from the extremal functions. This requires derivation of \eqn{P_x}
#'
#' @param n sample size
#' @param d dimension of the multivariate distribution
#' @param param a vector of parameters
#' @param model integer, currently ranging from 1 to 8, corresponding respectively to
#' (1) \code{log}, (2) \code{neglog}, (3) \code{dirmix}, (4) \code{bilog},
#' (5) \code{extstud}, (6) \code{hr}, (7) \code{ct} and (8) \code{smith}.
#' @param Sigma covariance matrix for Husler-Reiss, Smith and extremal student. Default for compatibility
#' @param loc matrix of location for Smith model.
#'
#' @return a \code{n} by \code{d} matrix containing the sample
.rmevA2 <- function(n, d, param, model, Sigma, loc) {
    .Call('mev_rmevA2', PACKAGE = 'mev', n, d, param, model, Sigma, loc)
}

#' Random number generator from spectral distribution
#'
#' Generate from \eqn{Q_i}{Qi}, the spectral measure of a given multivariate extreme value model
#'
#' @param n sample size
#' @param d dimension of the multivariate distribution
#' @param param a vector of parameters
#' @param model integer, currently ranging from 1 to 7, corresponding respectively to
#' (1) \code{log}, (2) \code{neglog}, (3) \code{dirmix}, (4) \code{bilog},
#' (5) \code{extstud}, (6) \code{hr}, (7) \code{ct} and (8) \code{smith}.
#' @param Sigma covariance matrix for Husler-Reiss and extremal student. Default for compatibility
#' @param loc matrix of locations for the Smith model
#'
#' @references Dombry, Engelke and Oesting (2015). Exact simulation of max-stable processes, \emph{arXiv:1506.04430v1}, 1--24.
#' @references Boldi (2009). A note on the representation of parametric models for multivariate extremes. \emph{Extremes} \bold{12}, 211--218.
#'
#' @return a \code{n} by \code{d} matrix containing the sample
.rmevspec_cpp <- function(n, d, param, model, Sigma, loc) {
    .Call('mev_rmevspec_cpp', PACKAGE = 'mev', n, d, param, model, Sigma, loc)
}

#' Random number generator from asymmetric logistic distribution
#'
#' Simulation algorithm of Stephenson (2003), using exact-samples from the logistic
#'
#' @param n sample size
#' @param d dimension of the multivariate distribution
#' @param param a vector of parameters
#' @param asym matrix of bool indicating which component belong to the corresponding row logistic model
#' @param ncompo number of components for the (negative) logistic in row
#' @param Sigma matrix of asymmetry parameters
#'
#' @references Stephenson, A. G. (2003) Simulating multivariate extreme value distributions of logistic type.
#' \emph{Extremes}, \bf{6}(1), 49--60.
#' @references Joe, H. (1990). Families of min-stable multivariate exponential and multivariate
#' extreme value distributions, \bf{9}, 75--81.
#'
#' @return a \code{n} by \code{d} matrix containing the sample
.rmevasy <- function(n, d, param, asym, ncompo, Sigma, model) {
    .Call('mev_rmevasy', PACKAGE = 'mev', n, d, param, asym, ncompo, Sigma, model)
}

