% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builders.R
\name{build_Lambda}
\alias{build_Lambda}
\title{Build the \eqn{\Lambda} matrix}
\usage{
build_Lambda(aggregation, n_lags)
}
\arguments{
\item{aggregation}{A character vector of length \code{n_vars} with elements being \code{'identity'}, \code{'average'} or \code{'triangular'} to indicate the type of aggregation scheme to assume.}

\item{n_lags}{The number of lags.}
}
\value{
\item{Lambda}{An \code{n_vars * (n_vars*n_pseudolags)} matrix, where \code{n_pseudolags} is \code{max(5, n_lags)} if any variable uses the triangular aggregation scheme, \code{max(3, n_lags)} if any uses the quarterly average.}
}
\description{
Builds the aggregation matrix \eqn{\Lambda}.
}
\details{
The choice \code{aggregation = "identity"} means that what is observed is assumed to be exactly the underlying variable, whereas \code{aggregation = "average"} uses the quarterly average of the monthly underlying observations. Lastly, \code{aggregation = "triangular"} uses the triangular specification used by Mariano and Murasawa (2010).
}
\keyword{internal}
