% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{apply_shift_scale}
\alias{apply_shift_scale}
\title{Shift and scale vector x}
\usage{
apply_shift_scale(x, scale = NULL, shift = NULL)
}
\arguments{
\item{x}{A vector of predictor variable}

\item{scale}{scaling factors for x of interest. Must be positive integers.
Default is NULL and  scaling factors are automatically estimated using
find_scale_factor() function else it uses user supplied scaling factors. If no scaling
is needed just use scale = 1}

\item{shift}{adjustment factors required for shifting x to positive
values. Default is NULL and adjustment factors are estimated automatically
using find_shift_factor() function}
}
\value{
A numeric value that has been shifted and scaled.
}
\description{
A function that is used to shift x values to positive values if it contains
negative or zero values.If all values of x are positive then the original
values of x is returned without shifting but scaled if the scaling factor is
not equal to 1. If x has already been shifted and scaled then the function does
nothing.
}
\examples{
x = 1:1000
apply_shift_scale(x)

}
