% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mgcv_smooth_2D.R,
%   R/plot_multi_mgcv_smooth_2D.R
\name{plot.mgcv.smooth.2D}
\alias{plot.mgcv.smooth.2D}
\alias{plot.multi.mgcv.smooth.2D}
\title{Plotting two dimensional smooth effects}
\usage{
\method{plot}{mgcv.smooth.2D}(
  x,
  n = 40,
  xlim = NULL,
  ylim = NULL,
  maxpo = 10000,
  too.far = 0.1,
  trans = identity,
  seWithMean = FALSE,
  unconditional = FALSE,
  ...
)

\method{plot}{multi.mgcv.smooth.2D}(
  x,
  n = 30,
  xlim = NULL,
  ylim = NULL,
  maxpo = 10000,
  too.far = 0.1,
  trans = identity,
  seWithMean = FALSE,
  unconditional = FALSE,
  a.facet = list(),
  ...
)
}
\arguments{
\item{x}{a smooth effect object, extracted using \link[mgcViz:sm]{mgcViz::sm}.}

\item{n}{sqrt of the number of grid points used to compute the effect plot.}

\item{xlim}{if supplied then this pair of numbers are used as the x limits for the plot.}

\item{ylim}{if supplied then this pair of numbers are used as the y limits for the plot.}

\item{maxpo}{maximum number of residuals points that will be used by layers such as
\code{resRug()} and \code{resPoints()}. If number of datapoints > \code{maxpo},
then a subsample of \code{maxpo} points will be taken.}

\item{too.far}{if greater than 0 then this is used to determine when a location is too far
from data to be plotted. This is useful since smooths tend to go wild
away from data. The data are scaled into the unit square before deciding
what to exclude, and too.far is a distance within the unit square.
Setting to zero can make plotting faster for large datasets, but care
then needed with interpretation of plots.}

\item{trans}{monotonic function to apply to the smooth and residuals, before plotting.
Monotonicity is not checked.}

\item{seWithMean}{if TRUE the component smooths are shown with confidence intervals that
include the uncertainty about the overall mean. If FALSE then the uncertainty
relates purely to the centred smooth itself. Marra and Wood (2012) suggests
that TRUE results in better coverage performance, and this is also suggested
by simulation.}

\item{unconditional}{if \code{TRUE} then the smoothing parameter uncertainty corrected covariance
matrix is used to compute uncertainty bands, if available.
Otherwise the bands treat the smoothing parameters as fixed.}

\item{...}{currently unused.}

\item{a.facet}{arguments to be passed to \link[ggplot2:facet_wrap]{ggplot2::facet_wrap} or \link[ggplot2:facet_grid]{ggplot2::facet_grid}. The former gets
called when \code{fix} contains one vector, the latter when \code{fix} contains two vectors.}
}
\value{
An objects of class \code{plotSmooth}.
}
\description{
Plotting method for two dimensional smooth effects.
}
\examples{
library(mgcViz)
set.seed(2) ## simulate some data...
dat <- gamSim(1, n = 700, dist = "normal", scale = 2)
b <- gam(y ~ s(x0) + s(x1, x2) + s(x3), data = dat, method = "REML")
b <- getViz(b)

# Plot 2D effect with noised-up raster, contour and rug for design points 
# Opacity is proportional to the significance of the effect
plot(sm(b, 2)) + l_fitRaster(pTrans = zto1(0.05, 2, 0.1), noiseup = TRUE) + 
  l_rug() + l_fitContour()  

# Plot contour of effect joint density of design points
plot(sm(b, 2)) + l_dens(type = "joint") + l_points() + l_fitContour() + 
  coord_cartesian(expand = FALSE) # Fill the plot
  
###
# Quantile GAM example
###
b <- mqgamV(y ~ s(x0) + s(x1, x2) + s(x3), qu = c(0.3, 0.7), data = dat)

plot(sm(b, 2)) + l_fitRaster(noiseup = TRUE) + l_fitContour(colour = 2)

}
\references{
Marra, G and S.N. Wood (2012) Coverage Properties of Confidence Intervals for
Generalized Additive Model Components. Scandinavian Journal of Statistics.
}
