% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgee2k.R
\name{mgee2k}
\alias{mgee2k}
\title{mgee2k}
\usage{
mgee2k(
  obsform,
  id,
  obsdat,
  OR.str = "exchangeable",
  W.nam,
  gamMat,
  varphiMat,
  maxit = 50,
  tol = 0.001
)
}
\arguments{
\item{obsform}{a formula object which specifies the relationship between 
the response and covariates for the observed data.}

\item{id}{a character object which records individual id in the data.}

\item{obsdat}{a dataframe or matrix object for the observed data set.}

\item{OR.str}{a character object. The default value is "exchangeable", 
corresponding to the structure where the association between two paired 
responses is considered to be a constant. The other option is "log-linear" 
which  indicates the log-linear association between two paired responses.}

\item{W.nam}{a character object which names the error-prone covariate W.}

\item{gamMat}{a matrix object which records the misclassification parameter gamma for response Y.}

\item{varphiMat}{a matrix object which records the misclassification parameter phi for covariate X.}

\item{maxit}{an integer which specifies the maximum number of iterations. The default is 50.}

\item{tol}{a numeric object which indicates the tolerance threshold. The default is 1e-3.}
}
\value{
A list with component
    \item{beta}{Coefficients in the order as those specified in the formula for the response and covariates.}
    \item{alpha}{Coefficients for paired responses global odds ratios. The number of 
    alpha coefficients corresponds to the paired responses odds ratio structure selected
     in OR.str. When OR.str="exchangeable", only one baseline alpha 
     is fitted. When OR.str="log-linear", baseline, first order, 
     second order (interaction) terms are fitted.}
    \item{variance}{variance-covariance matrix of the estimator of all parameters.}
    \item{convergence}{a logical variable; TRUE if the model converges.}
    \item{iteration}{the number of iterations for the estimates of the model parameters to converge.}
    \item{differ}{a list of difference of estimation for convergence}   
    \item{call}{Function called}
}
\description{
Corrected GEE2 for ordinal data. This method yields unbiased estimators, but the
misclassification parameters are required to known.
}
\examples{
  if(0){
  data(obs1)
  obs1$visit <- as.factor(obs1$visit)
  obs1$treatment <- as.factor(obs1$treatment)
  obs1$S <- as.factor(obs1$S)
  obs1$W <- as.factor(obs1$W)
  ## set misclassification parameters to be known.
  varphiMat <- gamMat <- log( cbind(0.04/0.95, 0.01/0.95,
                                    0.95/0.03, 0.02/0.03,
                                    0.04/0.01, 0.95/0.01) )
  mgee2k.fit = mgee2k(obsform = S~W+treatment+visit, id = "ID", obsdat = obs1,
                    OR.str = "exchangeable", W.nam = "W", gamMat = gamMat, 
                    varphiMat = varphiMat)
  }
}
