% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildFromEnsgs_function.R
\name{buildFromEnsgs}
\alias{buildFromEnsgs}
\title{Build empty list using ENSG gene ids.}
\usage{
buildFromEnsgs(ensg)
}
\arguments{
\item{ensg}{A character vector with ENSG gene ids}
}
\description{
\code{buildFromEnsgs} returns an empty 'mgl' list given ensembl ENSG gene ids.
}
\details{
This is one of three functions that can be used to set up the list structure.  It starts
  with ENSG gene ids.
}
\examples{
\dontrun{buildFromEnsgs(ensg = 
c('ENSG00000087237', 'ENSG00000165029', 'ENSG00000084674')) -> myMgl}

}
\seealso{
Other Build list: \code{\link{buildFromNames}},
  \code{\link{buildFromRegion}}
}

