% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixNames_function.R
\name{fixNames}
\alias{fixNames}
\title{Fix genes with missing names}
\usage{
fixNames(mgl, ensgs)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{ensgs}{A character vector of ensgs for missing genes. Note: These should be in the same order as the output from missNames!}
}
\description{
\code{fixNames} fixes gene name element for those that were not found in ensembl
}
\details{
This gives basic information on gene nomenclature for those genes that were missed by the \code{\link{buildFromNames}} function.  Use of ENSG identifier eliminates ambiguity while pairing with external gene name enhances human readability.  ENSG identifiers are required for many of the remaining functions in the package.
}
\section{Details}{

If a gene is not found, a warning message will appear when the function geneNames is run: 'Gene names missing: ...'. This must be corrected or no other elements can be filled in as the remaining elements all build off of the disambigous ENSG identifier.  There are two strategies to fix this.  The first is to check gene names for typos or use of less common colloquial names.  The second is to use the missNames and fixNames functions in this pacakge to fill in the missing ENSG identifiers.  Note: googling the colloquial gene name and 'gene cards' is an excellent way to find an ENSG id.  Genecards does an exceptional job of cataloging alternative colloquial names.
}
\examples{
\dontrun{buildFromNames(c('CETP', 'APBO', '1ABCA')) -> myMgl}
\dontrun{missNames(myMgl)}
\dontrun{fixNames(myMgl, c('ENSG00000084674', 'ENSG00000165029'))}

}
\seealso{
\code{\link{missNames}}
}

