% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_mir_terms.R
\name{compare_mir_terms_unique}
\alias{compare_mir_terms_unique}
\title{Compare terms uniquely associated with a miRNA name}
\usage{
compare_mir_terms_unique(
  df,
  mir,
  top = 20,
  token = "words",
  ...,
  topic = NULL,
  stopwords = stopwords_miretrieve,
  stopwords_ngram = TRUE,
  normalize = TRUE,
  colour = "steelblue3",
  col.mir = miRNA,
  col.abstract = Abstract,
  col.topic = Topic,
  col.pmid = PMID,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing miRNA names, abstracts, topics, and PubMed-IDs.}

\item{mir}{String. miRNA name of interest.}

\item{top}{Integer. Number of top terms to plot.}

\item{token}{String. Specifies how abstracts shall be split up. Taken from
\code{unnest_tokens()} in the \pkg{tidytext} package:
"Unit for tokenizing, or a custom tokenizing function. Built-in options are
"words" (default), "characters", "character_shingles", "ngrams", "skip_ngrams",
"sentences", "lines", "paragraphs", "regex",
(...),
and "ptb" (Penn Treebank). If a function, should take a character vector and
return a list of character vectors of the same length."}

\item{...}{Additional arguments for tokenization, if necessary.}

\item{topic}{Character vector. Optional. Specifies which topics to plot.
If \code{topic = NULL}, all topics in \code{df} are plotted.}

\item{stopwords}{Data frame containing stop words.}

\item{stopwords_ngram}{Boolean. Specifies if stop words shall be removed
from abstracts when using ngrams. Only applied when \code{token = 'ngrams'}.}

\item{normalize}{Boolean. If \code{normalize = TRUE}, relative term frequency is
plotted, denoting the relative number of papers with \code{mir} mentioning the term
compared to all papers with \code{mir} mentioning the term. If \code{normalize = FALSE},
absolute term frequency is plotted, denoting the number of papers with \code{mir}
the term is mentioned in.}

\item{colour}{String. Colour of bar plot.}

\item{col.mir}{Symbol. Column containing miRNAs.}

\item{col.abstract}{Symbol. Column containing abstracts.}

\item{col.topic}{Symbol. Column containing topics names.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{title}{String. Plot title.}
}
\value{
Bar plot containing unique miRNA-terms associations per topic.
}
\description{
Compare terms uniquely associated with a miRNA name over topics.
}
\details{
Compare terms uniquely associated with a miRNA name over topics.
miRNA names and topics must be in a data frame \code{df}, while terms are taken
from abstracts contained in \code{df}.
Number of top terms to choose is regulated by \code{top}. Terms are
evaluated either as the number of times they are mentioned in all abstracts
with the miRNA name of interest, or the number of times they are relatively mentioned
compared to all abstracts with the miRNA name of interest.
\code{compare_mir_terms_unique()} is based on the tools available in the
\pkg{tidytext} package.
}
\seealso{
\code{\link[=compare_mir_terms]{compare_mir_terms()}}, \code{\link[=compare_mir_terms_log2]{compare_mir_terms_log2()}}, \code{\link[=compare_mir_terms_scatter]{compare_mir_terms_scatter()}}

Other compare functions: 
\code{\link{compare_mir_count_log2}()},
\code{\link{compare_mir_count_unique}()},
\code{\link{compare_mir_count}()},
\code{\link{compare_mir_terms_log2}()},
\code{\link{compare_mir_terms_scatter}()},
\code{\link{compare_mir_terms}()}
}
\concept{compare functions}
