% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micomp.R
\name{micomp}
\alias{micomp}
\title{Multiple independent comparisons of observations}
\usage{
micomp(outputs, ve_npcs, comps, concat = F, centscal = "range",
  lim_npcs = TRUE, mnv_test = "Pillai", ...)
}
\arguments{
\item{outputs}{A vector with the labels of each output, or an integer with
the number of outputs (in which case output labels will be assigned
automatically).}

\item{ve_npcs}{Percentage (\code{0 < ve_npcs < 1}) of variance explained by
the \emph{q} principal components (i.e. number of dimensions) used in MANOVA,
or the number of principal components (\code{ve_npcs > 1}, must be integer).
Can be a vector, in which case the MANOVA test will be applied multiple
times, one per specified variance to explain / number of principal
components.}

\item{comps}{A list of lists, where each list contains information regarding
an individual comparison. Each list can have one of two configurations:
\enumerate{
  \item Lists with the first configuration are used to load data from files,
        and require the following fields:
    \describe{
      \item{name}{A string specifying the comparison name.}
      \item{folders}{Vector of folder names where to read files from. These
            are recycled if \code{length(folders) < length(files)}.}
      \item{files}{Vector of filenames (with wildcards) to load in each
            folder.}
      \item{lvls}{Vector of level or group names, must be the same length as
            \code{files}, i.e. each file set will be associated with a
            different group. If not given, default group names will be set.}
    }
  \item Lists with the second configuration are used to load data from
        environment variables, and require the following fields:
    \describe{
      \item{name}{A string specifying the comparison name.}
      \item{grpout}{Either an object of class \code{\link{grpoutputs}} or a
            list with the following two fields:
        \describe{
          \item{data}{List of all outputs, where tags correspond to output
                names and values correspond to the output data. Output data
                is a \emph{n} x \emph{m} matrix, where \emph{n} is the total
                number of output observations and \emph{m} is the number of
                variables (i.e. output length). }
          \item{obs_lvls}{Levels or groups associated with each observation.}
        }
      }
    }
}}

\item{concat}{Create an additional, concatenated output? Ignored for sublists
passed in the \code{comps} which follow the second configuration.}

\item{centscal}{Method for centering and scaling outputs if \code{concat} is
TRUE. It can be one of "center", "auto", "range" (default), "iqrange",
"vast", "pareto" or "level". Centering and scaling is performed by the
\code{\link{centerscale}} function.}

\item{lim_npcs}{Limit number of principal components used for MANOVA to
minimum number of observations per group?}

\item{mnv_test}{The name of the test statistic to be used in MANOVA, as
described in \code{\link[stats]{summary.manova}}.}

\item{...}{Options passed to \code{\link[utils]{read.table}}, which is used
to read the files specified in lists using the first configuration in the
\code{comp} parameter.}
}
\value{
An object of class \code{micomp}, which is a two-dimensional
list of \code{\link{cmpoutput}} objects. Rows are associated with individual
outputs, while columns are associated with separate comparisons.
}
\description{
Performs multiple independent comparisons of output observations.
}
\examples{

# Create a micomp object from existing files and folders

dir_nl_ok <-
  system.file("extdata", "nl_ok", package = "micompr")
dir_jex_ok <-
  system.file("extdata", "j_ex_ok", package = "micompr")
dir_jex_noshuff <-
  system.file("extdata", "j_ex_noshuff", package = "micompr")
dir_jex_diff <-
  system.file("extdata", "j_ex_diff", package = "micompr")
files <- glob2rx("stats400v1*.tsv")

mic <- micomp(7, 0.8,
              list(list(name = "NLOKvsJEXOK",
                        folders = c(dir_nl_ok, dir_jex_ok),
                        files = c(files, files),
                        lvls = c("NLOK", "JEXOK")),
                   list(name = "NLOKvsJEXNOSHUFF",
                        folders = c(dir_nl_ok, dir_jex_noshuff),
                        files = c(files, files),
                        lvls = c("NLOK", "JEXNOSHUFF")),
                   list(name = "NLOKvsJEXDIFF",
                        folders = c(dir_nl_ok, dir_jex_diff),
                        files = c(files, files),
                        lvls = c("NLOK", "JEXDIFF"))),
              concat = TRUE)

\donttest{
# Create a micomp object from package datasets (i.e. grpoutputs objects)
# directly

mic <- micomp(c("o1", "o2", "o3", "o4"), 0.9,
              list(list(name = "NLOKvsJEXOK", grpout = pphpc_ok),
                   list(name = "NLOKvsJEXNOSHUFF", grpout = pphpc_noshuff),
                   list(name = "NLOKvsJEXDIFF", grpout = pphpc_diff)))

# Create a micomp object using manually inserted data

mic <- micomp(6, 0.5, list(
  list(name = "NLOKvsJEXOK",
       grpout = list(data = pphpc_ok$data,
                     obs_lvls = pphpc_ok$obs_lvls)),
  list(name = "NLOKvsJEXNOSHUFF",
       grpout = list(data = pphpc_noshuff$data,
                     obs_lvls = pphpc_noshuff$obs_lvls)),
  list(name = "NLOKvsJEXDIFF",
       grpout = list(data = pphpc_diff$data,
                     obs_lvls = pphpc_diff$obs_lvls))))
}
}
