% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers-static.R
\name{cran_static_path_handler}
\alias{cran_static_path_handler}
\alias{cran_static_redirect_handler}
\title{Handler for package repository files}
\usage{
cran_static_path_handler(repo_dir, path_prefix = NULL)

cran_static_redirect_handler(dest_url)
}
\arguments{
\item{repo_dir}{Path to local directory, where the root of the repository is.
The (source) packages will be stored locally at
\verb{\{repo_dir\}/src/contrib/}.}

\item{path_prefix}{Optional URL-component, if the repository exists at a
subdirectory of the host (see \link{run}'s \code{path}). Here, it is only for
decorative purposes.}

\item{dest_url}{The url requests are forwarded to, after being appened with
the request; it should contain all path-components up to the `/src` or `/bin`
parts.}
}
\value{
A handler (function) for use in a Plumber router "filter" .
}
\description{
Creates handler for handling access to static files in the repository,
i.e., the \code{src/contrib}, \code{bin/windows/contrib}, and \code{bin/macosx/contrib}
subdirectories.

Use \link{cran_static_redirect_handler} to let another process (e.g. an Apache httpd
or nginx server) handle the request, by redirecting it.
}
\examples{
require(plumber)
pr() |>
 pr_filter('static',
  cran_static_path_handler(repo_dir, path_prefix = 'cran'))
pr() |>
  pr_filter('redirect',
    cran_static_redirect_handler("http://my.local.cran:80/cran"))
}
