% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_radarPC.R
\name{pre_radarPC}
\alias{pre_radarPC}
\title{Compute the PCA to the \code{\link[=paired_times]{paired_times()}} output previously to visualize radar charts of principal components.}
\usage{
pre_radarPC(data, exp.var = 0.75, limit = 1.5)
}
\arguments{
\item{data}{input matrix with paired times.}

\item{exp.var}{desired explained variance, i.e. a value between 0 and 1.}

\item{limit}{times to distance an interquartile range from the first and third quartile; default is 1.5, i.e. the whiskers of a boxplot.}
}
\value{
The needed objects to later plot a radar chart (or spider plot) of principal components.
}
\description{
Compute the PCA to the \code{\link[=paired_times]{paired_times()}} output previously to visualize radar charts of principal components.
}
\examples{
t1_t2 <- paired_times(data = clr, first = "_1",
                      second = "_25", common = "_0_")
pre_radarPC(data = t1_t2, exp.var = 0.85)
}
