% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KmerCount.R
\name{KmerCount}
\alias{KmerCount}
\title{K-mer counting}
\usage{
KmerCount(sequences, K = 1, col.names = FALSE)
}
\arguments{
\item{sequences}{Vector of sequences (text).}

\item{K}{Word length (integer).}

\item{col.names}{Logical indicating if the words should be added as columns names.}
}
\value{
A matrix with one row for each sequence in \code{sequences} and one column for 
each possible word of length\code{K}.
}
\description{
Counting overlapping words of length K in DNA/RNA sequences.
}
\details{
For each input sequence, the frequency of every word of length \code{K} is counted. 
Counting is done with overlap. The counting itself is done by a C++ function.

With \code{col.names=TRUE} the K-mers are added as column names, but this makes the
computations slower.
}
\examples{
KmerCount("ATGCCTGAACTGACCTGC",K=2)

}
\seealso{
\code{\link{multinomTrain}}, \code{\link{multinomClassify}}.
}
\author{
Kristian Hovde Liland and Lars Snipen.
}
