% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarefaction.R
\name{plot.Rarefac}
\alias{plot.Rarefac}
\alias{summary.Rarefac}
\title{Plot and summary of \code{Rarefac} objects}
\usage{
\method{plot}{Rarefac}(x, type = "b", pch = 16, xlab = "Genomes",
  ylab = "Number of unique gene clusters", ...)

\method{summary}{Rarefac}(object, ...)
}
\arguments{
\item{x}{A \code{Rarefac} object, see below.}

\item{type}{Type of plot, default is \samp{"b"}, giving markers with lines between.}

\item{pch}{Marker type, default is \samp{16}, a filled circle.}

\item{xlab}{Text for horizontal axis.}

\item{ylab}{Text for vertical axis.}

\item{\dots}{Optional graphical arguments.}

\item{object}{A \code{Rarefac} object, see below.}
}
\description{
Generic functions for \code{Rarefac} object.
}
\details{
A \code{Rarefac} object is a small (S3) extension to a matrix. The first column contains
the cumulative number of unique gene clusters found when considering 1,2,...,G genomes in a pan-matrix.
Thus, the \code{Rarefac} object is a matrix with G rows. Any additional columns will hold similar
numbers, but for random shufflings of the genome's ordering. A \code{Rarefac} object is typically
created by the function \code{\link{rarefaction}}.

The \code{\link{plot.Rarefac}} function will display the content of the \code{Rarefac} object as a plot
of the mean value in rows 1,2,...,G, where G is the total number of genomes in the study.

The \code{\link{summary.Rarefac}} function will display a text giving the same information as
\code{\link{plot.Rarefac}}.
}
\examples{
# See examples in the Help-file for rarefaction.

}
\seealso{
\code{\link{rarefaction}}, \code{\link{heaps}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
