% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timePointGeneration.R
\name{getAllTimeOptions}
\alias{getAllTimeOptions}
\title{generate all possible time options from eligible time points and number of samples per time interval ( time zone )}
\usage{
getAllTimeOptions(timeZones, fullTimePoints)
}
\arguments{
\item{timeZones}{a data.frame containing information on the number of points to be chosen in each time zone. 
Each row is a time zone. 
\itemize{
  \item \code{startTime} the start time of each time zone assumed to be included in that zone
  \item \code{endTime} the end time of the zone. It is not part of the current zone but the start time of the next zone
  \item \code{nPointsPerZone} the number of time points to be chosen within each zone. 
}}

\item{fullTimePoints}{a numeric vector containing all possible time points to be considered including time point zero and the last time point}
}
\value{
\code{\link{SetOfTimePoints-class}}
}
\description{
generate all possible time options from eligible time points and number of samples per time interval ( time zone )
}
\details{
time point zero is never included in any time option and the last time point is always included. Note that the last 
time point is not a member of any zone. The number of time points in every time options is therefore the total number of time
points specified in \code{timeZone} plus 1 for the last time point.
}
\examples{
  timeZonesEx              <-  getExampleTimeZones()
  fullTimePointsEx         <-  seq( 0 , 21 , 1 )
  print(timeZonesEx)
  setOfTimePoints          <-  getAllTimeOptions( timeZones = timeZonesEx , 
     fullTimePoints = fullTimePointsEx )
  setOfTimePoints          <-  getAllTimeOptions( 
    timeZones = data.frame(startTime = 0 , endTime = 21 , nPointsPerZone = 1) , 
    fullTimePoints = fullTimePointsEx 
   )
}
