% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkFunctions.R
\name{getPkData}
\alias{getPkData}
\title{simulate \code{\link{PkData-class}} from \code{\link{PkModel-class}}}
\usage{
getPkData(pkModel, timePoints, nSubjectsPerScheme, nSamples,
  errorCorrelationMatrixIntime = diag(1, length(timePoints)),
  nCores = 1, dirIntermediateOutput = NULL)
}
\arguments{
\item{pkModel}{an object of \code{\link{PkModel-class}}}

\item{timePoints}{numeric vector of time points}

\item{nSubjectsPerScheme}{numeric constant, number of subjects per dataset on which a sampling scheme can be applied}

\item{nSamples}{number of datasets to sample}

\item{errorCorrelationMatrixIntime}{the correlation between additive error terms within a subject, by default no correlation}

\item{nCores}{number of cores used for parallel computing, defaults to 1 (remark no random numbers are generated in parallel)}

\item{dirIntermediateOutput}{directory to write intermediate output to for debugging, defaults to NULL, when no intermediate output is written down}
}
\value{
\code{\link{PkData-class}} object
}
\description{
simulate \code{\link{PkData-class}} from \code{\link{PkModel-class}}
}
\examples{
  getPkData( getExamplePkModel() , 0:5 , nSubjectsPerScheme = 3 , nSamples = 4  )
  getPkData( getExamplePkModel() , 0:5 , nSubjectsPerScheme = 7 , nSamples = 1  ) 
}
