% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schemeGenerator.R
\name{getSetOfSchemes}
\alias{getSetOfSchemes}
\title{Generate a  \code{\link{SetOfSchemes-class}} object of speficified dimensions ( subjects, observations per t) for a given 
set of time points which  meets user specified constraints}
\usage{
getSetOfSchemes(minNSubjects, maxNSubjects, minObsPerSubject,
  maxObsPerSubject, timePoints, constraints = NULL,
  maxRepetitionIndSchemes = 1, maxNumberOfSchemesBeforeChecks = 10^5,
  returnNSchemesBeforeConstraints = FALSE)
}
\arguments{
\item{minNSubjects}{numeric, the mimimum number of subjects per scheme}

\item{maxNSubjects}{numeric, the maximum number of subjects per scheme}

\item{minObsPerSubject}{numeric, the mimimum number of sampling occasions per subject}

\item{maxObsPerSubject}{numeric, the maximum number of sampling occasions per subject}

\item{timePoints}{numeric vector of time points larger then zero, at which subject can be sampled}

\item{constraints}{data.frame specifying constraints the scheme should meet.
  with columns:
  \itemize{
   \item check: identifier of the function to perform the check 
   \item level: the level at wich the check is applied: either at the subject level or scheme level
   \item value: input value used by the check function
}  
 (a user can add constraint functions following 
naming convention \code{check_[level]_[check]}  see examples:  ( \code{\link{check_scheme_minObsPerTimePoint}}  and \code{\link{check_subject_maxConsecSamples}}) )
remark: number of subjects per scheme or number of observations per scheme should not be specified in \code{constraints}}

\item{maxRepetitionIndSchemes}{the maximum number of times an individual subject scheme can be repeated, defaults to 1}

\item{maxNumberOfSchemesBeforeChecks}{the maximum number of schemes to consider before applying scheme constraints,
 to avoid to long processing and using up memory.
defaults to 10^5}

\item{returnNSchemesBeforeConstraints}{if \code{TRUE} return only number of schemes before checking constraints instead of the schemes themselves, defaults to \code{FALSE}}
}
\description{
Generate a  \code{\link{SetOfSchemes-class}} object of speficified dimensions ( subjects, observations per t) for a given 
set of time points which  meets user specified constraints
}
\note{
keep number of subjects , range of number of subjects and observations per subject and number of timep points restricted 
to avoid a large number of potential schemes slowing down computation and increasing memory usage

only schemes with minimal one observation per subject are contained even if not specified in constraints
}
\examples{
  timePoints          <-  c( 1.2 , 1.3 ,  2, 5  )
  constraints         <-  getConstraintsExample()
  ex1   <-  getSetOfSchemes( minNSubjects = 4 , maxNSubjects = 4 ,
    minObsPerSubject = 3 , maxObsPerSubject = 3 , timePoints , constraints )
  ex2   <-  getSetOfSchemes( minNSubjects = 4 , maxNSubjects = 4 ,
    minObsPerSubject = 3 , maxObsPerSubject = 3 , timePoints ,
    constraints ,  maxRepetitionIndSchemes = 1 )
  ex3   <-  getSetOfSchemes( minNSubjects = 4 , maxNSubjects = 4 , 
    minObsPerSubject = 2 , maxObsPerSubject = 3 , timePoints ,
    constraints , maxRepetitionIndSchemes = 1 )
  ex4   <-  getSetOfSchemes( minNSubjects = 2 , maxNSubjects = 5 ,
    minObsPerSubject = 2 , maxObsPerSubject = 3 , timePoints ,
    constraints , maxRepetitionIndSchemes = 1 )
  ex5   <-  getSetOfSchemes( minNSubjects = 2 , maxNSubjects = 5 ,
    minObsPerSubject = 2 , maxObsPerSubject = 3 , timePoints , 
    maxRepetitionIndSchemes = 2 )
  \dontrun{
    # this should trow an error (to many combinations required )
    ex6   <-  getSetOfSchemes( minNSubjects = 2 , maxNSubjects = 5 , 
       minObsPerSubject = 2 ,  maxObsPerSubject = 3 , timePoints ,
       maxRepetitionIndSchemes = 2 ,  maxNumberOfSchemesBeforeChecks = 1000 )
}
}
