% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multialign.R
\name{msaTrim}
\alias{msaTrim}
\title{Trimming multiple sequence alignments}
\usage{
msaTrim(msa, gap.end = 0.5, gap.mid = 0.9)
}
\arguments{
\item{msa}{A \code{Fasta} object containing a multiple alignment.}

\item{gap.end}{Fraction of gaps tolerated at the ends of the alignment (0-1).}

\item{gap.mid}{Fraction of gaps tolerated inside the alignment (0-1).}
}
\value{
The trimmed alignment is returned as a \code{Fasta} object.
}
\description{
Trimming a multiple sequence alignment by discarding columns with too many gaps.
}
\details{
A multiple alignment is trimmed by removing columns with too many indels (gap-symbols). Any 
columns containing a fraction of gaps larger than \code{gap.mid} are discarded. For this reason, \code{gap.mid}
should always be farily close to 1.0 therwise too many columns may be discarded, destroying the alignment.

Due to the
heuristics of multiple alignment methods, both ends of the alignment tend to be uncertain and most
of the trimming should be done at the ends. Starting at each end, columns are discarded as long as their fraction of gaps
surpasses \code{gap.end}. Typically \code{gap.end} can be much smaller than \code{gap.mid}, but if 
set too low you risk that all columns are discarded!
}
\examples{
\dontrun{
msa.file <- file.path(file.path(path.package("microseq"),"extdata"),"msa.fasta")
msa <- readFasta(msa.file)
print(nchar(msa$Sequence))
msa.trimmed <- msaTrim(msa)
print(nchar(msa.trimmed$Sequence))
}

}
\author{
Lars Snipen.
}
\seealso{
\code{\link{muscle}}, \code{\link{cmalign}}.
}

