% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zellner_revankar.R
\name{zellner_revankar}
\alias{zellner_revankar}
\title{Generalized production function}
\usage{
zellner_revankar(
  theta,
  y,
  Z,
  sum = FALSE,
  gradient = TRUE,
  hessian = TRUE,
  repar = TRUE
)
}
\arguments{
\item{theta}{the vector of parameters}

\item{y}{the vector of response}

\item{Z}{the matrix of covariates}

\item{sum}{if \code{FALSE}, a vector of individual contributions to the
likelihood and the matrix of individual contributions to the
gradient are returned, if \code{TRUE} a log-likelihood scalar and a
gradient vector are returned}

\item{gradient}{if \code{TRUE}, the gradient is returned as an attribute}

\item{hessian}{if \code{TRUE}, the hessian is returned as an attrubute}

\item{repar}{if \code{TRUE}, the likelihood is parametrized such that
the constant return to scale hypothesis implies that two
coefficients are 0}
}
\value{
a function.
}
\description{
Log-likelihood function for the generalized production function of
Zellner and Revankar (1969)
}
\references{
\insertRef{ZELL:REVA:69}{micsr}
}
\author{
Yves Croissant
}
