% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tobit1.R
\name{tobit1}
\alias{tobit1}
\alias{fitted.tobit1}
\title{Truncated response model}
\usage{
tobit1(
  formula,
  data,
  subset,
  weights,
  na.action,
  offset,
  contrasts = NULL,
  start = NULL,
  left = 0,
  right = Inf,
  scedas = NULL,
  sample = c("censored", "truncated"),
  method = c("ml", "lm", "twostep", "trimmed", "nls", "minchisq", "test"),
  opt = c("bfgs", "nr", "newton"),
  maxit = 100,
  trace = 0,
  check_gradient = FALSE,
  ...
)

\method{fitted}{tobit1}(object, ...)
}
\arguments{
\item{formula}{a symbolic description of the model; if two right
hand sides are provided, the second one described the set of
instruments if \code{scedas} is \code{NULL}, which is the
default. Otherwise, the second part indicates the set of
covariates for the variance function}

\item{data, subset, weights, na.action, offset, contrasts}{see \code{lm}}

\item{start}{an optional vector of starting values}

\item{left, right}{left and right truncation points for the response
The default is respectively 0 and +Inf which corresponds to the
most classic (left-zero truncated) tobit model}

\item{scedas}{the functional form used to specify the conditional
variance, either \code{"exp"} or \code{"pnorm"}}

\item{sample}{either \code{"censored"} (the default) to estimate the
censored (tobit) regression model or \code{"truncated"} to estimated
the truncated regression model}

\item{method}{one of \code{"ml"} for maximum likelihood, \code{"lm"} for
(biased) least squares estimators, \code{"twostep"} for two-steps
consistent estimators, \code{"trimmed"} for symetrically censored
estimator, \code{"minchisq"} and \code{"test"}. The last two are only
relevant for instrumental variable estimation (when the formula
is a two-parts formula and \code{scedas} is \code{NULL})}

\item{opt}{optimization method}

\item{maxit}{maximum number of iterations}

\item{trace}{printing of intermediate result}

\item{check_gradient}{if \code{TRUE} the numeric gradient and hessian
are computed and compared to the analytical gradient and
hessian}

\item{...}{further arguments}

\item{object}{a \code{tobit1} object}
}
\value{
An object of class \code{c("tobit1", "micsr")}, see
\code{micsr::micsr} for further details.
}
\description{
Estimation of models for which the response is truncated, either on
censored or truncated samples using OLS, NLS, maximum
likelihood, two-steps estimators or trimmed estimators
}
\examples{
charitable$logdon <- with(charitable, log(donation) - log(25))
ml <- tobit1(logdon ~ log(donparents) + log(income) + education +
             religion + married + south, data = charitable)
scls <- update(ml, method = "trimmed")
tr <- update(ml, sample = "truncated")
nls <- update(tr, method = "nls")
}
\references{
\insertRef{POWE:86}{micsr}
}
\author{
Yves Croissant
}
\keyword{models}
