% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_sgl.R
\name{reg_sgl}
\alias{reg_sgl}
\title{Linear sg-LASSO regression}
\usage{
reg_sgl(X, y, index, gamma_w = NULL, full_est = NULL, 
  method_choice = c("ic", "cv", "initial"), nlam = 100, lambdas = NULL, 
  min_frac = NULL, nfolds = 10, lambda_choice = c("min", "1se"), 
  ic_choice = c("bic", "aic", "aicc"), num_cores = NULL, verbose = FALSE, 
  thresh = NULL, outer_thresh = NULL, inner_iter = NULL, outer_iter = NULL)
}
\arguments{
\item{X}{T by p data matrix, where t and p respectively denote the sample size and the number of regressors.}

\item{y}{T by 1 vector of outcome.}

\item{index}{p by 1 vector indicating group membership of each covariate.}

\item{gamma_w}{sg-LASSO mixing parameter. \code{gamma_w = 1} is LASSO and \code{gamma_w = 0} group LASSO.}

\item{full_est}{pre-estimated parameters based on full sample and \code{regress_choice} for a sequence of \eqn{\lambda}'s.}

\item{method_choice}{choose between `initial`, `ic` and `cv`. `initial` pre-computes initial estimates. `ic` comptes solution based on information criteria (BIC, AIC or AICc). `cv` computes solution based on cross-validation (cv).}

\item{nlam}{number of \eqn{\lambda}'s to use in the regularization path.}

\item{lambdas}{user specified sequence of \eqn{\lambda} values for fitting. We recommend leaving this to NULL and letting function to self-select values.}

\item{min_frac}{the minimum value of the penalty parameter, as a fraction of the maximum value.}

\item{nfolds}{number of folds of the cv loop.}

\item{lambda_choice}{chose between `min` and `1se`. `min` computes solution that minimizes the cv error. `1se` computes solution such that the cv error is within 1 standard error of the minimum `min`.}

\item{ic_choice}{choose between `bic`, `aic` and `aicc`. `bic` computes solution that minimizes Bayesian information criterion. `aic` computes solution that minimizes Akaike information criterion. `aicc` omputes solution that minimizes Akaike information corrected criterion.}

\item{num_cores}{number of cores used to compute cv loop.}

\item{verbose}{flag to print information.}

\item{thresh}{convergence threshold for change in beta. We recommend leaving this to NULL.}

\item{outer_thresh}{outer loop convergence threshold. We recommend leaving this to NULL.}

\item{inner_iter}{the maximum number of inner sg-LASSO loop iterations. We recommend leaving this to NULL.}

\item{outer_iter}{the maximum number of outer sg-LASSO loop iterations. We recommend leaving this to NULL.}
}
\value{
Parameter estimates of linear regression model under sg-LASSO penalty.
}
\description{
Fits sg-LASSO least squares regression model. Options include cross-validation and information criteria for \eqn{\lambda} penalty parameter selection.
}
\details{
\ifelse{html}{\out{The sequence of linear regression models implied by <code>lambdas</code> vector is fit by block coordinate-descent. The objective function is <br><br> <center> RSS(&alpha;,&beta;)/T + 2&lambda;  &Omega;<sub>&gamma;</sub>(&beta;), </center> <br> where RSS(&alpha;,&beta;) is the least squares fit. The penalty function &Omega;<sub>&gamma;</sub>(.) is applied on  &beta; coefficients and is <br> <br> <center> &Omega;<sub>&gamma;</sub>(&beta;) = &gamma; |&beta;|<sub>1</sub> + (1-&gamma;)||&beta;||<sub>2,1</sub>, </center> <br> a convex combination of LASSO and group LASSO penalty functions.}}{The sequence of linear regression models implied by \code{lambdas} vector is fit by block coordinate-descent. The objective function is \deqn{RSS(\alpha,\beta)/T + 2\lambda * \Omega_\gamma(\beta),} where \eqn{RSS(\alpha,\beta)} is the least squares fit. The penalty function \eqn{\Omega_\gamma(.)} is applied on \eqn{\beta} coefficients and is \deqn{\Omega_\gamma(\beta) = \gamma |\beta|_1 + (1-\gamma)||\beta||_{2,1},} a convex combination of LASSO and group LASSO penalty functions.}
}
\examples{
set.seed(1)
x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
index = 1:20
reg_sgl(X = x, y = y, index = index, gamma_w = 1, method_choice = "initial", 
  num_cores = 2, verbose = FALSE)
}
\author{
Jonas Striaukas
}
