% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_yhat.R
\name{get.yhat}
\alias{get.yhat}
\alias{get.yhat.default}
\alias{get.yhat.mid}
\alias{get.yhat.lm}
\alias{get.yhat.glm}
\alias{get.yhat.rpart}
\alias{get.yhat.randomForest}
\alias{get.yhat.ranger}
\alias{get.yhat.svm}
\alias{get.yhat.ksvm}
\alias{get.yhat.AccurateGLM}
\alias{get.yhat.glmnet}
\alias{get.yhat.model_fit}
\alias{get.yhat.rpf}
\title{Wrapper Prediction Function}
\usage{
get.yhat(X.model, newdata, ...)

\method{get.yhat}{default}(X.model, newdata, target = -1L, ...)

\method{get.yhat}{mid}(X.model, newdata, ...)

\method{get.yhat}{lm}(X.model, newdata, ...)

\method{get.yhat}{glm}(X.model, newdata, ...)

\method{get.yhat}{rpart}(X.model, newdata, target = -1L, ...)

\method{get.yhat}{randomForest}(X.model, newdata, target = -1L, ...)

\method{get.yhat}{ranger}(X.model, newdata, target = -1L, ...)

\method{get.yhat}{svm}(X.model, newdata, target = -1L, ...)

\method{get.yhat}{ksvm}(X.model, newdata, target = -1L, ...)

\method{get.yhat}{AccurateGLM}(X.model, newdata, ...)

\method{get.yhat}{glmnet}(X.model, newdata, ...)

\method{get.yhat}{model_fit}(X.model, newdata, target = -1L, ...)

\method{get.yhat}{rpf}(X.model, newdata, target = -1L, ...)
}
\arguments{
\item{X.model}{a fitted model object.}

\item{newdata}{a data.frame or matrix.}

\item{...}{optional parameters that are passed to the prediction method for the model.}

\item{target}{an integer or character vector specifying the target levels for the prediction, used for the models that returns a matrix or data.frame of class probabilities. Default is \code{-1}, representing the probability of not being the base level.}
}
\value{
\code{get.yhat()} returns a numeric vector of model predictions for the \code{newdata}.
}
\description{
\code{get.yhat()} works as a proxy prediction function for many classes of fitted models.
}
\details{
\code{get.yhat()} is a wrapper prediction function for many classes of models.
Although many predictive models have their own method of \code{stats::predict()}, the structure and the type of the output of these methods are not uniform.
\code{get.yhat()} is designed to always return a simple numeric vector of model predictions.
The design of \code{get.yhat()} is strongly influenced by \code{DALEX::yhat()}.
}
\examples{
data(trees, package = "datasets")
model <- glm(Volume ~ ., trees, family = Gamma(log))
predict(model, trees[1:5, ], type = "response")
get.yhat(model, trees[1:5, ])
}
