% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectorNull.R
\name{dict_selectors_null}
\alias{dict_selectors_null}
\alias{SelectorNull}
\title{Null Selector}
\description{
\code{\link{Selector}} that disregards fitness and individual values and selects individuals by order in which they are given.
}
\section{Configuration Parameters}{



\itemize{
\item \code{shuffle_selection} :: \code{logical(1)}\cr
Whether to shuffle the selected output. When this is \code{TRUE}, selected individuals are returned in random order, so when this
operator is e.g. used in \code{\link[=mies_generate_offspring]{mies_generate_offspring()}}, then subsequent recombination operators effectively operate on pairs
(or larger groups) of random individuals. Otherwise they are returned in order, and recombination operates on the first
batch of \code{n_indivs_in} returned individuals first, then the second batch etc. in order. Initialized to \code{TRUE} (recommended).
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are: \code{\link[paradox:ParamLgl]{ParamLgl}}, \code{\link[paradox:ParamInt]{ParamInt}}, \code{\link[paradox:ParamDbl]{ParamDbl}}, \code{\link[paradox:ParamFct]{ParamFct}}
}

\section{Dictionary}{

This \code{\link{Selector}} can be created with the short access form \code{\link[=sel]{sel()}}
(\code{\link[=sels]{sels()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_selectors}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
sel("null")
sels("null")  # takes vector IDs, returns list of Selectors

# long form:
dict_selectors$get("null")
}\if{html}{\out{</div>}}
}

\examples{
sn = sel("null")
p = ps(x = p_dbl(-5, 5))
# dummy data; note that SelectorNull does not depend on data content
data = data.frame(x = rep(0, 5))
fitnesses = c(1, 5, 2, 3, 0)

sn$prime(p)

sn$operate(data, fitnesses, 2)
sn$operate(data, fitnesses, 4)
sn$operate(data, fitnesses, 6)
}
\seealso{
Other selectors: 
\code{\link{SelectorScalar}},
\code{\link{Selector}},
\code{\link{dict_selectors_best}},
\code{\link{dict_selectors_maybe}},
\code{\link{dict_selectors_proxy}},
\code{\link{dict_selectors_random}},
\code{\link{dict_selectors_sequential}},
\code{\link{dict_selectors_tournament}}
}
\concept{selectors}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Selector]{miesmuschel::Selector}} -> \code{SelectorNull}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SelectorNull-new}{\code{SelectorNull$new()}}
\item \href{#method-SelectorNull-clone}{\code{SelectorNull$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SelectorNull-new"></a>}}
\if{latex}{\out{\hypertarget{method-SelectorNull-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{SelectorNull} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SelectorNull$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SelectorNull-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SelectorNull-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SelectorNull$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
