% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_to.R
\name{reformat}
\alias{reformat}
\alias{to_uniplex}
\alias{to_undirected}
\alias{to_redirected}
\alias{to_unweighted}
\alias{to_unsigned}
\alias{to_unnamed}
\alias{to_named}
\alias{to_simplex}
\alias{to_onemode}
\alias{to_multilevel}
\alias{to_twomode}
\title{Tools for reformatting networks, graphs, and matrices}
\usage{
to_uniplex(object, edge)

to_undirected(object)

to_redirected(object)

to_unweighted(object, threshold = 1)

to_unsigned(object, keep = c("positive", "negative"))

to_unnamed(object)

to_named(object, names = NULL)

to_simplex(object)

to_onemode(object)

to_multilevel(object)

to_twomode(object, mark)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{edge}{Character string naming an edge attribute to retain from a graph.}

\item{threshold}{For a matrix, the threshold to binarise/dichotomise at.}

\item{keep}{In the case of a signed network, whether to retain
the "positive" or "negative" ties.}

\item{names}{Character vector of the node names. NULL by default.}

\item{mark}{A logical vector marking two types or modes.
By default "type".}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions offer tools for reformatting migraph-consistent objects
(matrices, igraph, tidygraph, or network objects).
Unlike the \verb{as_*()} group of functions,
these functions always return the same object type as they are given,
only transforming these objects' properties.
}
\details{
Since some modifications are easier to implement for some objects than others,
here are the currently implemented modifications:\tabular{lccccc}{
   to_ \tab edgelists \tab matrices \tab igraph \tab tidygraph \tab network \cr
   unweighted \tab X \tab X \tab X \tab X \tab X \cr
   undirected \tab  \tab X \tab X \tab X \tab X \cr
   redirected \tab X \tab X \tab X \tab X \tab  \cr
   unsigned \tab X \tab X \tab X \tab X \tab  \cr
   uniplex \tab  \tab  \tab X \tab X \tab  \cr
   unnamed \tab X \tab X \tab X \tab X \tab X \cr
   named \tab X \tab X \tab X \tab X \tab X \cr
   simplex \tab  \tab X \tab X \tab X \tab  \cr
   onemode \tab  \tab  \tab X \tab X \tab  \cr
   multilevel \tab  \tab X \tab X \tab X \tab  \cr
}
}
\section{Functions}{
\itemize{
\item \code{to_uniplex()}: Returns an object that includes only a single type of tie

\item \code{to_undirected()}: Returns an object that has any edge direction removed,
so that any pair of nodes with at least one directed edge will be
connected by an undirected edge in the new network.
This is equivalent to the "collapse" mode in \code{{igraph}}.

\item \code{to_redirected()}: Returns an object that has any edge direction transposed,
or flipped, so that senders become receivers and receivers become senders.
This essentially has no effect on undirected networks or reciprocated ties.

\item \code{to_unweighted()}: Returns an object that has all edge weights removed

\item \code{to_unsigned()}: Returns a network with either just the "positive" ties
or just the "negative" ties

\item \code{to_unnamed()}: Returns an object with all vertex names removed

\item \code{to_named()}: Returns an object that has random vertex names added

\item \code{to_simplex()}: Returns an object that has all loops or self-ties removed

\item \code{to_onemode()}: Returns an object that has any type/mode attributes removed,
but otherwise includes all the same nodes and ties.
Note that this is not the same as \code{to_mode1()} or \code{to_mode2()},
which return only some of the nodes and new ties established by coincidence.

\item \code{to_multilevel()}: Returns a network that is not divided into two mode types
but embeds two or more modes into a multimodal network structure.

\item \code{to_twomode()}: Returns a network that divides the nodes into two mode types.

}}
\examples{
autographr(ison_algebra)
a <- to_uniplex(ison_algebra, "friends")
autographr(a)
a <- to_giant(a)
autographr(a)
a <- to_undirected(a)
autographr(a)
a <- to_unweighted(a)
autographr(a)
}
\seealso{
Other manipulations: 
\code{\link{add}},
\code{\link{as}()},
\code{\link{grab}},
\code{\link{split}()},
\code{\link{transform}()}
}
\concept{manipulations}
