% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add}
\alias{add}
\alias{add_node_attributes}
\alias{add_edge_attributes}
\alias{copy_node_attributes}
\alias{mutate_edges}
\title{Adding and copying attributes from one graph to another}
\usage{
add_node_attributes(object, attr_name, vector)

add_edge_attributes(object, object2)

copy_node_attributes(object, object2)

mutate_edges(object, object2, attr_name)
}
\arguments{
\item{object}{A migraph-consistent object.}

\item{attr_name}{Name of the new attribute in the resulting object.}

\item{vector}{A vector of values for the new attribute.}

\item{object2}{A second object to copy nodes or edges from.}
}
\description{
Adding and copying attributes from one graph to another
}
\examples{
add_node_attributes(mpn_elite_mex, "wealth", 1:11)
add_node_attributes(mpn_elite_usa_advice, "wealth", 1:14)
autographr(mpn_elite_mex)
both <- mutate_edges(mpn_elite_mex, generate_random(mpn_elite_mex), "random")
autographr(both)
random <- to_uniplex(both, "random")
autographr(random)
autographr(to_uniplex(both, "orig"))
}
